/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.core.loader;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.spi.NewInstanceServiceLoader;
import io.shardingsphere.transaction.spi.xa.DataSourceMapConverter;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SPIDataSourceMapConverter
implements DataSourceMapConverter {
    private static final Logger log = LoggerFactory.getLogger(SPIDataSourceMapConverter.class);
    private static DataSourceMapConverter dataSourceMapConverter;

    private static void init() {
        Collection converters = NewInstanceServiceLoader.load(DataSourceMapConverter.class);
        if (converters.isEmpty()) {
            log.info("Could not find XA DataSourceConverter, XA transaction will not be effective");
            return;
        }
        dataSourceMapConverter = (DataSourceMapConverter)converters.iterator().next();
    }

    @Override
    public Map<String, DataSource> convert(Map<String, DataSource> dataSourceMap, DatabaseType databaseType) {
        return null != dataSourceMapConverter ? dataSourceMapConverter.convert(dataSourceMap, databaseType) : null;
    }

    static {
        SPIDataSourceMapConverter.init();
    }
}

