/*
 * Decompiled with CFR 0.152.
 */
package org.junit.extensions.cpsuite;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.extensions.cpsuite.ClassTester;
import org.junit.extensions.cpsuite.SuiteType;
import org.junit.runner.RunWith;

public class ClasspathSuiteTester
implements ClassTester {
    private final boolean searchInJars;
    private final SuiteType[] suiteTypes;
    private List<String> positiveFilters;
    private List<String> negationFilters;
    private final Class<?>[] baseTypes;
    private final Class<?>[] excludedBaseTypes;

    public ClasspathSuiteTester(boolean searchInJars, String[] filterPatterns, SuiteType[] suiteTypes, Class<?>[] baseTypes, Class<?>[] excludedBaseTypes) {
        this.searchInJars = searchInJars;
        this.positiveFilters = this.findPositiveFilters(filterPatterns);
        this.negationFilters = this.findNegationFilters(filterPatterns);
        this.suiteTypes = suiteTypes;
        this.baseTypes = baseTypes;
        this.excludedBaseTypes = excludedBaseTypes;
    }

    @Override
    public boolean acceptClass(Class<?> clazz) {
        if (this.isInSuiteTypes(SuiteType.TEST_CLASSES) && this.acceptTestClass(clazz)) {
            return true;
        }
        if (this.isInSuiteTypes(SuiteType.JUNIT38_TEST_CLASSES) && this.acceptJUnit38Test(clazz)) {
            return true;
        }
        if (this.isInSuiteTypes(SuiteType.RUN_WITH_CLASSES)) {
            return this.acceptRunWithClass(clazz);
        }
        return false;
    }

    private boolean acceptJUnit38Test(Class<?> clazz) {
        if (this.isAbstractClass(clazz)) {
            return false;
        }
        if (this.hasExcludedBaseType(clazz)) {
            return false;
        }
        if (!this.hasCorrectBaseType(clazz)) {
            return false;
        }
        return TestCase.class.isAssignableFrom(clazz);
    }

    private boolean acceptRunWithClass(Class<?> clazz) {
        return clazz.isAnnotationPresent(RunWith.class);
    }

    private boolean isInSuiteTypes(SuiteType suiteType) {
        return Arrays.asList(this.suiteTypes).contains((Object)suiteType);
    }

    private boolean acceptTestClass(Class<?> clazz) {
        if (this.isAbstractClass(clazz)) {
            return false;
        }
        if (this.hasExcludedBaseType(clazz)) {
            return false;
        }
        if (!this.hasCorrectBaseType(clazz)) {
            return false;
        }
        try {
            for (Method method : clazz.getMethods()) {
                if (method.getAnnotation(Test.class) == null) continue;
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }

    private boolean hasExcludedBaseType(Class<?> clazz) {
        for (Class<?> excludedBaseType : this.excludedBaseTypes) {
            if (!excludedBaseType.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCorrectBaseType(Class<?> clazz) {
        for (Class<?> baseType : this.baseTypes) {
            if (!baseType.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean isAbstractClass(Class<?> clazz) {
        return (clazz.getModifiers() & 0x400) != 0;
    }

    @Override
    public boolean acceptClassName(String className) {
        if (!this.acceptInPositiveFilers(className)) {
            return false;
        }
        return this.acceptInNegationFilters(className);
    }

    private boolean acceptInNegationFilters(String className) {
        for (String pattern : this.negationFilters) {
            if (!className.matches(pattern)) continue;
            return false;
        }
        return true;
    }

    private boolean acceptInPositiveFilers(String className) {
        boolean isPositiveAccepted = this.positiveFilters.isEmpty();
        for (String pattern : this.positiveFilters) {
            if (className.matches(pattern)) {
                isPositiveAccepted = true;
                break;
            }
            isPositiveAccepted = false;
        }
        return isPositiveAccepted;
    }

    private List<String> findPositiveFilters(String[] filterPatterns) {
        ArrayList<String> filters = new ArrayList<String>();
        if (filterPatterns != null) {
            for (String pattern : filterPatterns) {
                if (pattern.startsWith("!")) continue;
                filters.add(pattern);
            }
        }
        return filters;
    }

    private List<String> findNegationFilters(String[] filterPatterns) {
        ArrayList<String> filters = new ArrayList<String>();
        for (String pattern : filterPatterns) {
            if (!pattern.startsWith("!")) continue;
            filters.add(pattern.substring(1));
        }
        return filters;
    }

    @Override
    public boolean acceptInnerClass() {
        return true;
    }

    @Override
    public boolean searchInJars() {
        return this.searchInJars;
    }

    public List<String> getPositiveClassnameFilters() {
        return this.positiveFilters;
    }

    public List<String> getNegationClassnameFilters() {
        return this.negationFilters;
    }

    public SuiteType[] getSuiteTypes() {
        return this.suiteTypes;
    }

    public Class<?>[] getBaseTypes() {
        return this.baseTypes;
    }

    public Class<?>[] getExcludedBaseTypes() {
        return this.excludedBaseTypes;
    }
}

