/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.WebSocketImplBase;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.VertxHandler;

abstract class Http1xConnectionBase<S extends WebSocketImplBase<S>>
extends ConnectionBase
implements HttpConnection {
    protected S ws;

    Http1xConnectionBase(VertxInternal vertx, ChannelHandlerContext chctx, ContextInternal context) {
        super(vertx, chctx, context);
    }

    WebSocketFrame encodeFrame(WebSocketFrameImpl frame) {
        ByteBuf buf = frame.getBinaryData();
        if (buf != Unpooled.EMPTY_BUFFER) {
            buf = VertxHandler.safeBuffer(buf, this.chctx.alloc());
        }
        switch (frame.type()) {
            case BINARY: {
                return new BinaryWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case TEXT: {
                return new TextWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case CLOSE: {
                return new CloseWebSocketFrame(true, 0, buf);
            }
            case CONTINUATION: {
                return new ContinuationWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case PONG: {
                return new PongWebSocketFrame(buf);
            }
            case PING: {
                return new PingWebSocketFrame(buf);
            }
        }
        throw new IllegalStateException("Unsupported websocket msg " + frame);
    }

    private WebSocketFrameInternal decodeFrame(WebSocketFrame msg) {
        FrameType frameType;
        ByteBuf payload = VertxHandler.safeBuffer((ByteBufHolder)msg, this.chctx.alloc());
        boolean isFinal = msg.isFinalFragment();
        if (msg instanceof BinaryWebSocketFrame) {
            frameType = FrameType.BINARY;
        } else if (msg instanceof CloseWebSocketFrame) {
            frameType = FrameType.CLOSE;
        } else if (msg instanceof PingWebSocketFrame) {
            frameType = FrameType.PING;
        } else if (msg instanceof PongWebSocketFrame) {
            frameType = FrameType.PONG;
        } else if (msg instanceof TextWebSocketFrame) {
            frameType = FrameType.TEXT;
        } else if (msg instanceof ContinuationWebSocketFrame) {
            frameType = FrameType.CONTINUATION;
        } else {
            throw new IllegalStateException("Unsupported websocket msg " + msg);
        }
        return new WebSocketFrameImpl(frameType, payload, isFinal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWsFrame(WebSocketFrame msg) {
        S w;
        WebSocketFrameInternal frame = this.decodeFrame(msg);
        Http1xConnectionBase http1xConnectionBase = this;
        synchronized (http1xConnectionBase) {
            switch (frame.type()) {
                case PING: {
                    this.chctx.writeAndFlush((Object)new PongWebSocketFrame(frame.getBinaryData().copy()));
                    break;
                }
                case CLOSE: {
                    Http1xConnectionBase http1xConnectionBase2 = this;
                    synchronized (http1xConnectionBase2) {
                        break;
                    }
                }
            }
            w = this.ws;
        }
        if (w != null) {
            ((WebSocketImplBase)w).handleFrame(frame);
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        S socket;
        Http1xConnectionBase http1xConnectionBase = this;
        synchronized (http1xConnectionBase) {
            socket = this.ws;
        }
        if (socket != null) {
            socket.close();
        } else {
            super.close(handler);
        }
    }

    @Override
    public Http1xConnectionBase closeHandler(Handler<Void> handler) {
        return (Http1xConnectionBase)super.closeHandler(handler);
    }

    @Override
    public Http1xConnectionBase exceptionHandler(Handler<Throwable> handler) {
        return (Http1xConnectionBase)super.exceptionHandler(handler);
    }

    @Override
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection shutdownHandler(@Nullable Handler<Void> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection shutdown(long timeoutMs) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public Http2Settings settings() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public Http2Settings remoteSettings() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection ping(Buffer data, Handler<AsyncResult<Buffer>> pongHandler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    public HttpConnection pingHandler(@Nullable Handler<Buffer> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }
}

