/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class AbstractJDBCAction<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractJDBCAction.class);
    protected final Vertx vertx;
    protected final Connection conn;
    protected final ContextInternal ctx;
    protected final TaskQueue statementsQueue;
    protected final JDBCStatementHelper helper;

    protected AbstractJDBCAction(Vertx vertx, Connection conn, ContextInternal ctx, TaskQueue statementsQueue) {
        this(vertx, null, conn, ctx, statementsQueue);
    }

    protected AbstractJDBCAction(Vertx vertx, JDBCStatementHelper helper, Connection conn, ContextInternal ctx, TaskQueue statementsQueue) {
        this.vertx = vertx;
        this.conn = conn;
        this.ctx = ctx;
        this.statementsQueue = statementsQueue;
        this.helper = helper;
    }

    private void handle(Future<T> future) {
        try {
            T result = this.execute();
            future.complete(result);
        }
        catch (SQLException e) {
            future.fail((Throwable)e);
        }
    }

    public void execute(Handler<AsyncResult<T>> resultHandler) {
        this.ctx.executeBlocking(this::handle, this.statementsQueue, resultHandler);
    }

    protected abstract T execute() throws SQLException;

    protected abstract String name();
}

