/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.ResultSet;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;

public class JDBCCallable
extends AbstractJDBCAction<ResultSet> {
    private final String sql;
    private final JsonArray in;
    private final JsonArray out;
    private final int timeout;

    public JDBCCallable(Vertx vertx, JDBCStatementHelper helper, Connection connection, ContextInternal ctx, TaskQueue statementsQueue, int timeout, String sql, JsonArray in, JsonArray out) {
        super(vertx, helper, connection, ctx, statementsQueue);
        this.sql = sql;
        this.in = in;
        this.out = out;
        this.timeout = timeout;
    }

    @Override
    protected ResultSet execute() throws SQLException {
        try (CallableStatement statement = this.conn.prepareCall(this.sql);){
            if (this.timeout >= 0) {
                statement.setQueryTimeout(this.timeout);
            }
            this.helper.fillStatement(statement, this.in, this.out);
            boolean retResult = statement.execute();
            boolean outResult = this.out != null && this.out.size() > 0;
            ResultSet resultSet = null;
            if (retResult) {
                ResultSet ref = null;
                while (retResult) {
                    try (java.sql.ResultSet rs = statement.getResultSet();){
                        if (ref == null) {
                            ref = resultSet = this.helper.asList(rs);
                        } else {
                            ref.setNext(this.helper.asList(rs));
                            ref = ref.getNext();
                        }
                        if (outResult) {
                            ref.setOutput(this.convertOutputs(statement));
                        }
                    }
                    retResult = statement.getMoreResults();
                }
            } else if (outResult) {
                resultSet = new ResultSet(Collections.emptyList(), Collections.emptyList(), null).setOutput(this.convertOutputs(statement));
            }
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
    }

    private JsonArray convertOutputs(CallableStatement statement) throws SQLException {
        JsonArray result = new JsonArray();
        for (int i = 0; i < this.out.size(); ++i) {
            Object var = this.out.getValue(i);
            if (var != null) {
                Object value = statement.getObject(i + 1);
                if (value == null) {
                    result.addNull();
                    continue;
                }
                if (value instanceof java.sql.ResultSet) {
                    result.add((Object)this.helper.asList((java.sql.ResultSet)value));
                    continue;
                }
                result.add(JDBCStatementHelper.convertSqlValue(value));
                continue;
            }
            result.addNull();
        }
        return result;
    }

    @Override
    protected String name() {
        return "callable";
    }
}

