/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.UpdateResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Pattern;

public class JDBCUpdate
extends AbstractJDBCAction<UpdateResult> {
    private static final Pattern regex = Pattern.compile("(^|\\s)insert(\\s|$)", 10);
    private final String sql;
    private final JsonArray in;
    private final int timeout;

    public JDBCUpdate(Vertx vertx, JDBCStatementHelper helper, Connection connection, ContextInternal ctx, TaskQueue statementsQueue, int timeout, String sql, JsonArray in) {
        super(vertx, helper, connection, ctx, statementsQueue);
        this.sql = sql;
        this.in = in;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UpdateResult execute() throws SQLException {
        boolean returKeys = regex.matcher(this.sql).groupCount() == 2;
        try (PreparedStatement statement = this.conn.prepareStatement(this.sql, returKeys ? 1 : 2);){
            if (this.timeout >= 0) {
                statement.setQueryTimeout(this.timeout);
            }
            this.helper.fillStatement(statement, this.in);
            int updated = statement.executeUpdate();
            JsonArray keys = new JsonArray();
            if (returKeys) {
                ResultSet rs = null;
                try {
                    rs = statement.getGeneratedKeys();
                    if (rs != null) {
                        while (rs.next()) {
                            Object key = rs.getObject(1);
                            if (key == null) continue;
                            keys.add(JDBCStatementHelper.convertSqlValue(key));
                        }
                    }
                }
                catch (SQLException sQLException) {
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            UpdateResult updateResult = new UpdateResult(updated, keys);
            return updateResult;
        }
    }

    @Override
    protected String name() {
        return "update";
    }
}

