/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jwt;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jwt.JWTOptions;
import java.util.ArrayList;

public class JWTOptionsConverter {
    public static void fromJson(JsonObject json, JWTOptions obj) {
        ArrayList<String> list;
        if (json.getValue("algorithm") instanceof String) {
            obj.setAlgorithm((String)json.getValue("algorithm"));
        }
        if (json.getValue("audience") instanceof JsonArray) {
            list = new ArrayList<String>();
            json.getJsonArray("audience").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)item);
                }
            });
            obj.setAudience(list);
        }
        if (json.getValue("audiences") instanceof JsonArray) {
            json.getJsonArray("audiences").forEach(item -> {
                if (item instanceof String) {
                    obj.addAudience((String)item);
                }
            });
        }
        if (json.getValue("expiresInMinutes") instanceof Number) {
            obj.setExpiresInMinutes(((Number)json.getValue("expiresInMinutes")).intValue());
        }
        if (json.getValue("expiresInSeconds") instanceof Number) {
            obj.setExpiresInSeconds(((Number)json.getValue("expiresInSeconds")).intValue());
        }
        if (json.getValue("header") instanceof JsonObject) {
            obj.setHeader(((JsonObject)json.getValue("header")).copy());
        }
        if (json.getValue("ignoreExpiration") instanceof Boolean) {
            obj.setIgnoreExpiration((Boolean)json.getValue("ignoreExpiration"));
        }
        if (json.getValue("issuer") instanceof String) {
            obj.setIssuer((String)json.getValue("issuer"));
        }
        if (json.getValue("leeway") instanceof Number) {
            obj.setLeeway(((Number)json.getValue("leeway")).intValue());
        }
        if (json.getValue("noTimestamp") instanceof Boolean) {
            obj.setNoTimestamp((Boolean)json.getValue("noTimestamp"));
        }
        if (json.getValue("permissions") instanceof JsonArray) {
            list = new ArrayList();
            json.getJsonArray("permissions").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)item);
                }
            });
            obj.setPermissions(list);
        }
        if (json.getValue("subject") instanceof String) {
            obj.setSubject((String)json.getValue("subject"));
        }
    }

    public static void toJson(JWTOptions obj, JsonObject json) {
        JsonArray array;
        if (obj.getAlgorithm() != null) {
            json.put("algorithm", obj.getAlgorithm());
        }
        if (obj.getAudience() != null) {
            array = new JsonArray();
            obj.getAudience().forEach(item -> array.add(item));
            json.put("audience", array);
        }
        json.put("expiresInSeconds", Integer.valueOf(obj.getExpiresInSeconds()));
        if (obj.getHeader() != null) {
            json.put("header", obj.getHeader());
        }
        json.put("ignoreExpiration", Boolean.valueOf(obj.isIgnoreExpiration()));
        if (obj.getIssuer() != null) {
            json.put("issuer", obj.getIssuer());
        }
        json.put("leeway", Integer.valueOf(obj.getLeeway()));
        json.put("noTimestamp", Boolean.valueOf(obj.isNoTimestamp()));
        if (obj.getPermissions() != null) {
            array = new JsonArray();
            obj.getPermissions().forEach(item -> array.add(item));
            json.put("permissions", array);
        }
        if (obj.getSubject() != null) {
            json.put("subject", obj.getSubject());
        }
    }
}

