/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.redis;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.impl.AsyncResultCompletable;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import io.vertx.reactivex.redis.RedisTransaction;
import io.vertx.reactivex.redis.Script;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.BitFieldOptions;
import io.vertx.redis.op.BitFieldOverflowOptions;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.ClientReplyOptions;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.GeoUnit;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.LimitOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.ScriptDebugOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.SortOptions;
import java.util.List;
import java.util.Map;

@RxGen(value=io.vertx.redis.RedisClient.class)
public class RedisClient {
    public static final TypeArg<RedisClient> __TYPE_ARG = new TypeArg(obj -> new RedisClient((io.vertx.redis.RedisClient)obj), RedisClient::getDelegate);
    private final io.vertx.redis.RedisClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisClient that = (RedisClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RedisClient(io.vertx.redis.RedisClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.redis.RedisClient getDelegate() {
        return this.delegate;
    }

    public static RedisClient create(Vertx vertx) {
        RedisClient ret = RedisClient.newInstance(io.vertx.redis.RedisClient.create(vertx.getDelegate()));
        return ret;
    }

    public static RedisClient create(Vertx vertx, RedisOptions config) {
        RedisClient ret = RedisClient.newInstance(io.vertx.redis.RedisClient.create(vertx.getDelegate(), config));
        return ret;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Completable rxClose() {
        return new AsyncResultCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient append(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.append(key, value, handler);
        return this;
    }

    public Single<Long> rxAppend(String key, String value) {
        return new AsyncResultSingle(handler -> this.append(key, value, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient auth(String password, Handler<AsyncResult<String>> handler) {
        this.delegate.auth(password, handler);
        return this;
    }

    public Single<String> rxAuth(String password) {
        return new AsyncResultSingle(handler -> this.auth(password, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient bgrewriteaof(Handler<AsyncResult<String>> handler) {
        this.delegate.bgrewriteaof(handler);
        return this;
    }

    public Single<String> rxBgrewriteaof() {
        return new AsyncResultSingle(handler -> this.bgrewriteaof((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient bgsave(Handler<AsyncResult<String>> handler) {
        this.delegate.bgsave(handler);
        return this;
    }

    public Single<String> rxBgsave() {
        return new AsyncResultSingle(handler -> this.bgsave((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient bitcount(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitcount(key, handler);
        return this;
    }

    public Single<Long> rxBitcount(String key) {
        return new AsyncResultSingle(handler -> this.bitcount(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient bitcountRange(String key, long start, long end, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitcountRange(key, start, end, handler);
        return this;
    }

    public Single<Long> rxBitcountRange(String key, long start, long end) {
        return new AsyncResultSingle(handler -> this.bitcountRange(key, start, end, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitop(operation, destkey, keys, handler);
        return this;
    }

    public Single<Long> rxBitop(BitOperation operation, String destkey, List<String> keys) {
        return new AsyncResultSingle(handler -> this.bitop(operation, destkey, keys, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient bitpos(String key, int bit, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitpos(key, bit, handler);
        return this;
    }

    public Single<Long> rxBitpos(String key, int bit) {
        return new AsyncResultSingle(handler -> this.bitpos(key, bit, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient bitposFrom(String key, int bit, int start, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitposFrom(key, bit, start, handler);
        return this;
    }

    public Single<Long> rxBitposFrom(String key, int bit, int start) {
        return new AsyncResultSingle(handler -> this.bitposFrom(key, bit, start, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitposRange(key, bit, start, stop, handler);
        return this;
    }

    public Single<Long> rxBitposRange(String key, int bit, int start, int stop) {
        return new AsyncResultSingle(handler -> this.bitposRange(key, bit, start, stop, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient blpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.blpop(key, seconds, handler);
        return this;
    }

    public Single<JsonArray> rxBlpop(String key, int seconds) {
        return new AsyncResultSingle(handler -> this.blpop(key, seconds, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient blpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.blpopMany(keys, seconds, handler);
        return this;
    }

    public Single<JsonArray> rxBlpopMany(List<String> keys, int seconds) {
        return new AsyncResultSingle(handler -> this.blpopMany(keys, seconds, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient brpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.brpop(key, seconds, handler);
        return this;
    }

    public Single<JsonArray> rxBrpop(String key, int seconds) {
        return new AsyncResultSingle(handler -> this.brpop(key, seconds, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient brpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.brpopMany(keys, seconds, handler);
        return this;
    }

    public Single<JsonArray> rxBrpopMany(List<String> keys, int seconds) {
        return new AsyncResultSingle(handler -> this.brpopMany(keys, seconds, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpoplpush(key, destkey, seconds, handler);
        return this;
    }

    public Single<String> rxBrpoplpush(String key, String destkey, int seconds) {
        return new AsyncResultSingle(handler -> this.brpoplpush(key, destkey, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient clientKill(KillFilter filter, Handler<AsyncResult<Long>> handler) {
        this.delegate.clientKill(filter, handler);
        return this;
    }

    public Single<Long> rxClientKill(KillFilter filter) {
        return new AsyncResultSingle(handler -> this.clientKill(filter, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient clientList(Handler<AsyncResult<String>> handler) {
        this.delegate.clientList(handler);
        return this;
    }

    public Single<String> rxClientList() {
        return new AsyncResultSingle(handler -> this.clientList((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient clientGetname(Handler<AsyncResult<String>> handler) {
        this.delegate.clientGetname(handler);
        return this;
    }

    public Single<String> rxClientGetname() {
        return new AsyncResultSingle(handler -> this.clientGetname((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient clientPause(long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.clientPause(millis, handler);
        return this;
    }

    public Single<String> rxClientPause(long millis) {
        return new AsyncResultSingle(handler -> this.clientPause(millis, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient clientSetname(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.clientSetname(name, handler);
        return this;
    }

    public Single<String> rxClientSetname(String name) {
        return new AsyncResultSingle(handler -> this.clientSetname(name, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient clusterAddslots(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterAddslots(slots, handler);
        return this;
    }

    public Completable rxClusterAddslots(List<Long> slots) {
        return new AsyncResultCompletable(handler -> this.clusterAddslots(slots, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterCountFailureReports(String nodeId, Handler<AsyncResult<Long>> handler) {
        this.delegate.clusterCountFailureReports(nodeId, handler);
        return this;
    }

    public Single<Long> rxClusterCountFailureReports(String nodeId) {
        return new AsyncResultSingle(handler -> this.clusterCountFailureReports(nodeId, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient clusterCountkeysinslot(long slot, Handler<AsyncResult<Long>> handler) {
        this.delegate.clusterCountkeysinslot(slot, handler);
        return this;
    }

    public Single<Long> rxClusterCountkeysinslot(long slot) {
        return new AsyncResultSingle(handler -> this.clusterCountkeysinslot(slot, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient clusterDelslots(long slot, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterDelslots(slot, handler);
        return this;
    }

    public Completable rxClusterDelslots(long slot) {
        return new AsyncResultCompletable(handler -> this.clusterDelslots(slot, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterDelslotsMany(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterDelslotsMany(slots, handler);
        return this;
    }

    public Completable rxClusterDelslotsMany(List<Long> slots) {
        return new AsyncResultCompletable(handler -> this.clusterDelslotsMany(slots, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterFailover(Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterFailover(handler);
        return this;
    }

    public Completable rxClusterFailover() {
        return new AsyncResultCompletable(handler -> this.clusterFailover((Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterFailOverWithOptions(options, handler);
        return this;
    }

    public Completable rxClusterFailOverWithOptions(FailoverOptions options) {
        return new AsyncResultCompletable(handler -> this.clusterFailOverWithOptions(options, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterForget(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterForget(nodeId, handler);
        return this;
    }

    public Completable rxClusterForget(String nodeId) {
        return new AsyncResultCompletable(handler -> this.clusterForget(nodeId, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterGetkeysinslot(slot, count, handler);
        return this;
    }

    public Single<JsonArray> rxClusterGetkeysinslot(long slot, long count) {
        return new AsyncResultSingle(handler -> this.clusterGetkeysinslot(slot, count, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient clusterInfo(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterInfo(handler);
        return this;
    }

    public Single<JsonArray> rxClusterInfo() {
        return new AsyncResultSingle(handler -> this.clusterInfo((Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient clusterKeyslot(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.clusterKeyslot(key, handler);
        return this;
    }

    public Single<Long> rxClusterKeyslot(String key) {
        return new AsyncResultSingle(handler -> this.clusterKeyslot(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient clusterMeet(String ip, long port, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterMeet(ip, port, handler);
        return this;
    }

    public Completable rxClusterMeet(String ip, long port) {
        return new AsyncResultCompletable(handler -> this.clusterMeet(ip, port, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterNodes(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterNodes(handler);
        return this;
    }

    public Single<JsonArray> rxClusterNodes() {
        return new AsyncResultSingle(handler -> this.clusterNodes((Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient clusterReplicate(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterReplicate(nodeId, handler);
        return this;
    }

    public Completable rxClusterReplicate(String nodeId) {
        return new AsyncResultCompletable(handler -> this.clusterReplicate(nodeId, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterReset(Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterReset(handler);
        return this;
    }

    public Completable rxClusterReset() {
        return new AsyncResultCompletable(handler -> this.clusterReset((Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterResetWithOptions(options, handler);
        return this;
    }

    public Completable rxClusterResetWithOptions(ResetOptions options) {
        return new AsyncResultCompletable(handler -> this.clusterResetWithOptions(options, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterSaveconfig(Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSaveconfig(handler);
        return this;
    }

    public Completable rxClusterSaveconfig() {
        return new AsyncResultCompletable(handler -> this.clusterSaveconfig((Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterSetConfigEpoch(long epoch, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSetConfigEpoch(epoch, handler);
        return this;
    }

    public Completable rxClusterSetConfigEpoch(long epoch) {
        return new AsyncResultCompletable(handler -> this.clusterSetConfigEpoch(epoch, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSetslot(slot, subcommand, handler);
        return this;
    }

    public Completable rxClusterSetslot(long slot, SlotCmd subcommand) {
        return new AsyncResultCompletable(handler -> this.clusterSetslot(slot, subcommand, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSetslotWithNode(slot, subcommand, nodeId, handler);
        return this;
    }

    public Completable rxClusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId) {
        return new AsyncResultCompletable(handler -> this.clusterSetslotWithNode(slot, subcommand, nodeId, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient clusterSlaves(String nodeId, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterSlaves(nodeId, handler);
        return this;
    }

    public Single<JsonArray> rxClusterSlaves(String nodeId) {
        return new AsyncResultSingle(handler -> this.clusterSlaves(nodeId, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient clusterSlots(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterSlots(handler);
        return this;
    }

    public Single<JsonArray> rxClusterSlots() {
        return new AsyncResultSingle(handler -> this.clusterSlots((Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient command(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.command(handler);
        return this;
    }

    public Single<JsonArray> rxCommand() {
        return new AsyncResultSingle(handler -> this.command((Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient commandCount(Handler<AsyncResult<Long>> handler) {
        this.delegate.commandCount(handler);
        return this;
    }

    public Single<Long> rxCommandCount() {
        return new AsyncResultSingle(handler -> this.commandCount((Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient commandGetkeys(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.commandGetkeys(handler);
        return this;
    }

    public Single<JsonArray> rxCommandGetkeys() {
        return new AsyncResultSingle(handler -> this.commandGetkeys((Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient commandInfo(List<String> commands, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.commandInfo(commands, handler);
        return this;
    }

    public Single<JsonArray> rxCommandInfo(List<String> commands) {
        return new AsyncResultSingle(handler -> this.commandInfo(commands, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient configGet(String parameter, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.configGet(parameter, handler);
        return this;
    }

    public Single<JsonArray> rxConfigGet(String parameter) {
        return new AsyncResultSingle(handler -> this.configGet(parameter, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient configRewrite(Handler<AsyncResult<String>> handler) {
        this.delegate.configRewrite(handler);
        return this;
    }

    public Single<String> rxConfigRewrite() {
        return new AsyncResultSingle(handler -> this.configRewrite((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.configSet(parameter, value, handler);
        return this;
    }

    public Single<String> rxConfigSet(String parameter, String value) {
        return new AsyncResultSingle(handler -> this.configSet(parameter, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient configResetstat(Handler<AsyncResult<String>> handler) {
        this.delegate.configResetstat(handler);
        return this;
    }

    public Single<String> rxConfigResetstat() {
        return new AsyncResultSingle(handler -> this.configResetstat((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient dbsize(Handler<AsyncResult<Long>> handler) {
        this.delegate.dbsize(handler);
        return this;
    }

    public Single<Long> rxDbsize() {
        return new AsyncResultSingle(handler -> this.dbsize((Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient debugObject(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.debugObject(key, handler);
        return this;
    }

    public Single<String> rxDebugObject(String key) {
        return new AsyncResultSingle(handler -> this.debugObject(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient debugSegfault(Handler<AsyncResult<String>> handler) {
        this.delegate.debugSegfault(handler);
        return this;
    }

    public Single<String> rxDebugSegfault() {
        return new AsyncResultSingle(handler -> this.debugSegfault((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient decr(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.decr(key, handler);
        return this;
    }

    public Single<Long> rxDecr(String key) {
        return new AsyncResultSingle(handler -> this.decr(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient decrby(String key, long decrement, Handler<AsyncResult<Long>> handler) {
        this.delegate.decrby(key, decrement, handler);
        return this;
    }

    public Single<Long> rxDecrby(String key, long decrement) {
        return new AsyncResultSingle(handler -> this.decrby(key, decrement, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient del(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.del(key, handler);
        return this;
    }

    public Single<Long> rxDel(String key) {
        return new AsyncResultSingle(handler -> this.del(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient delMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.delMany(keys, handler);
        return this;
    }

    public Single<Long> rxDelMany(List<String> keys) {
        return new AsyncResultSingle(handler -> this.delMany(keys, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient dump(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.dump(key, handler);
        return this;
    }

    public Single<String> rxDump(String key) {
        return new AsyncResultSingle(handler -> this.dump(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient echo(String message, Handler<AsyncResult<String>> handler) {
        this.delegate.echo(message, handler);
        return this;
    }

    public Single<String> rxEcho(String message) {
        return new AsyncResultSingle(handler -> this.echo(message, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.eval(script, keys, args, handler);
        return this;
    }

    public Single<JsonArray> rxEval(String script, List<String> keys, List<String> args) {
        return new AsyncResultSingle(handler -> this.eval(script, keys, args, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient evalsha(String sha1, List<String> keys, List<String> values, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.evalsha(sha1, keys, values, handler);
        return this;
    }

    public Single<JsonArray> rxEvalsha(String sha1, List<String> keys, List<String> values) {
        return new AsyncResultSingle(handler -> this.evalsha(sha1, keys, values, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient evalScript(Script script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.evalScript(script.getDelegate(), keys, args, handler);
        return this;
    }

    public Single<JsonArray> rxEvalScript(Script script, List<String> keys, List<String> args) {
        return new AsyncResultSingle(handler -> this.evalScript(script, keys, args, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient exists(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.exists(key, handler);
        return this;
    }

    public Single<Long> rxExists(String key) {
        return new AsyncResultSingle(handler -> this.exists(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient existsMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.existsMany(keys, handler);
        return this;
    }

    public Single<Long> rxExistsMany(List<String> keys) {
        return new AsyncResultSingle(handler -> this.existsMany(keys, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient expire(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.delegate.expire(key, seconds, handler);
        return this;
    }

    public Single<Long> rxExpire(String key, long seconds) {
        return new AsyncResultSingle(handler -> this.expire(key, seconds, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient expireat(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.delegate.expireat(key, seconds, handler);
        return this;
    }

    public Single<Long> rxExpireat(String key, long seconds) {
        return new AsyncResultSingle(handler -> this.expireat(key, seconds, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient flushall(Handler<AsyncResult<String>> handler) {
        this.delegate.flushall(handler);
        return this;
    }

    public Single<String> rxFlushall() {
        return new AsyncResultSingle(handler -> this.flushall((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient flushdb(Handler<AsyncResult<String>> handler) {
        this.delegate.flushdb(handler);
        return this;
    }

    public Single<String> rxFlushdb() {
        return new AsyncResultSingle(handler -> this.flushdb((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient get(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.get(key, handler);
        return this;
    }

    public Single<String> rxGet(String key) {
        return new AsyncResultSingle(handler -> this.get(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient getBinary(String key, final Handler<AsyncResult<Buffer>> handler) {
        this.delegate.getBinary(key, new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>(){

            public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Buffer.newInstance((io.vertx.core.buffer.Buffer)((io.vertx.core.buffer.Buffer)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<Buffer> rxGetBinary(String key) {
        return new AsyncResultSingle(handler -> this.getBinary(key, (Handler<AsyncResult<Buffer>>)handler));
    }

    public RedisClient getbit(String key, long offset, Handler<AsyncResult<Long>> handler) {
        this.delegate.getbit(key, offset, handler);
        return this;
    }

    public Single<Long> rxGetbit(String key, long offset) {
        return new AsyncResultSingle(handler -> this.getbit(key, offset, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.delegate.getrange(key, start, end, handler);
        return this;
    }

    public Single<String> rxGetrange(String key, long start, long end) {
        return new AsyncResultSingle(handler -> this.getrange(key, start, end, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient getset(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.getset(key, value, handler);
        return this;
    }

    public Single<String> rxGetset(String key, String value) {
        return new AsyncResultSingle(handler -> this.getset(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient hdel(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.delegate.hdel(key, field, handler);
        return this;
    }

    public Single<Long> rxHdel(String key, String field) {
        return new AsyncResultSingle(handler -> this.hdel(key, field, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient hdelMany(String key, List<String> fields, Handler<AsyncResult<Long>> handler) {
        this.delegate.hdelMany(key, fields, handler);
        return this;
    }

    public Single<Long> rxHdelMany(String key, List<String> fields) {
        return new AsyncResultSingle(handler -> this.hdelMany(key, fields, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient hexists(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.delegate.hexists(key, field, handler);
        return this;
    }

    public Single<Long> rxHexists(String key, String field) {
        return new AsyncResultSingle(handler -> this.hexists(key, field, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient hget(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hget(key, field, handler);
        return this;
    }

    public Single<String> rxHget(String key, String field) {
        return new AsyncResultSingle(handler -> this.hget(key, field, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient hgetall(String key, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.hgetall(key, handler);
        return this;
    }

    public Single<JsonObject> rxHgetall(String key) {
        return new AsyncResultSingle(handler -> this.hgetall(key, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public RedisClient hincrby(String key, String field, long increment, Handler<AsyncResult<Long>> handler) {
        this.delegate.hincrby(key, field, increment, handler);
        return this;
    }

    public Single<Long> rxHincrby(String key, String field, long increment) {
        return new AsyncResultSingle(handler -> this.hincrby(key, field, increment, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.hincrbyfloat(key, field, increment, handler);
        return this;
    }

    public Single<String> rxHincrbyfloat(String key, String field, double increment) {
        return new AsyncResultSingle(handler -> this.hincrbyfloat(key, field, increment, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient hkeys(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hkeys(key, handler);
        return this;
    }

    public Single<JsonArray> rxHkeys(String key) {
        return new AsyncResultSingle(handler -> this.hkeys(key, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient hlen(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.hlen(key, handler);
        return this;
    }

    public Single<Long> rxHlen(String key) {
        return new AsyncResultSingle(handler -> this.hlen(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient hmget(String key, List<String> fields, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hmget(key, fields, handler);
        return this;
    }

    public Single<JsonArray> rxHmget(String key, List<String> fields) {
        return new AsyncResultSingle(handler -> this.hmget(key, fields, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
        this.delegate.hmset(key, values, handler);
        return this;
    }

    public Single<String> rxHmset(String key, JsonObject values) {
        return new AsyncResultSingle(handler -> this.hmset(key, values, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient hset(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.hset(key, field, value, handler);
        return this;
    }

    public Single<Long> rxHset(String key, String field, String value) {
        return new AsyncResultSingle(handler -> this.hset(key, field, value, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient hsetnx(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.hsetnx(key, field, value, handler);
        return this;
    }

    public Single<Long> rxHsetnx(String key, String field, String value) {
        return new AsyncResultSingle(handler -> this.hsetnx(key, field, value, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient hvals(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hvals(key, handler);
        return this;
    }

    public Single<JsonArray> rxHvals(String key) {
        return new AsyncResultSingle(handler -> this.hvals(key, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient incr(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.incr(key, handler);
        return this;
    }

    public Single<Long> rxIncr(String key) {
        return new AsyncResultSingle(handler -> this.incr(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient incrby(String key, long increment, Handler<AsyncResult<Long>> handler) {
        this.delegate.incrby(key, increment, handler);
        return this;
    }

    public Single<Long> rxIncrby(String key, long increment) {
        return new AsyncResultSingle(handler -> this.incrby(key, increment, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.incrbyfloat(key, increment, handler);
        return this;
    }

    public Single<String> rxIncrbyfloat(String key, double increment) {
        return new AsyncResultSingle(handler -> this.incrbyfloat(key, increment, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient info(Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.info(handler);
        return this;
    }

    public Single<JsonObject> rxInfo() {
        return new AsyncResultSingle(handler -> this.info((Handler<AsyncResult<JsonObject>>)handler));
    }

    public RedisClient infoSection(String section, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.infoSection(section, handler);
        return this;
    }

    public Single<JsonObject> rxInfoSection(String section) {
        return new AsyncResultSingle(handler -> this.infoSection(section, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public RedisClient keys(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.keys(pattern, handler);
        return this;
    }

    public Single<JsonArray> rxKeys(String pattern) {
        return new AsyncResultSingle(handler -> this.keys(pattern, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient lastsave(Handler<AsyncResult<Long>> handler) {
        this.delegate.lastsave(handler);
        return this;
    }

    public Single<Long> rxLastsave() {
        return new AsyncResultSingle(handler -> this.lastsave((Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient lindex(String key, int index, Handler<AsyncResult<String>> handler) {
        this.delegate.lindex(key, index, handler);
        return this;
    }

    public Single<String> rxLindex(String key, int index) {
        return new AsyncResultSingle(handler -> this.lindex(key, index, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.linsert(key, option, pivot, value, handler);
        return this;
    }

    public Single<Long> rxLinsert(String key, InsertOptions option, String pivot, String value) {
        return new AsyncResultSingle(handler -> this.linsert(key, option, pivot, value, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient llen(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.llen(key, handler);
        return this;
    }

    public Single<Long> rxLlen(String key) {
        return new AsyncResultSingle(handler -> this.llen(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient lpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.lpop(key, handler);
        return this;
    }

    public Single<String> rxLpop(String key) {
        return new AsyncResultSingle(handler -> this.lpop(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient lpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.delegate.lpushMany(key, values, handler);
        return this;
    }

    public Single<Long> rxLpushMany(String key, List<String> values) {
        return new AsyncResultSingle(handler -> this.lpushMany(key, values, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient lpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.lpush(key, value, handler);
        return this;
    }

    public Single<Long> rxLpush(String key, String value) {
        return new AsyncResultSingle(handler -> this.lpush(key, value, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient lpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.lpushx(key, value, handler);
        return this;
    }

    public Single<Long> rxLpushx(String key, String value) {
        return new AsyncResultSingle(handler -> this.lpushx(key, value, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient lrange(String key, long from, long to, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.lrange(key, from, to, handler);
        return this;
    }

    public Single<JsonArray> rxLrange(String key, long from, long to) {
        return new AsyncResultSingle(handler -> this.lrange(key, from, to, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient lrem(String key, long count, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.lrem(key, count, value, handler);
        return this;
    }

    public Single<Long> rxLrem(String key, long count, String value) {
        return new AsyncResultSingle(handler -> this.lrem(key, count, value, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lset(key, index, value, handler);
        return this;
    }

    public Single<String> rxLset(String key, long index, String value) {
        return new AsyncResultSingle(handler -> this.lset(key, index, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.delegate.ltrim(key, from, to, handler);
        return this;
    }

    public Single<String> rxLtrim(String key, long from, long to) {
        return new AsyncResultSingle(handler -> this.ltrim(key, from, to, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient mget(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.mget(key, handler);
        return this;
    }

    public Single<JsonArray> rxMget(String key) {
        return new AsyncResultSingle(handler -> this.mget(key, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient mgetMany(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.mgetMany(keys, handler);
        return this;
    }

    public Single<JsonArray> rxMgetMany(List<String> keys) {
        return new AsyncResultSingle(handler -> this.mgetMany(keys, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.migrate(host, port, key, destdb, timeout, options, handler);
        return this;
    }

    public Single<String> rxMigrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options) {
        return new AsyncResultSingle(handler -> this.migrate(host, port, key, destdb, timeout, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient monitor(Handler<AsyncResult<Void>> handler) {
        this.delegate.monitor(handler);
        return this;
    }

    public Completable rxMonitor() {
        return new AsyncResultCompletable(handler -> this.monitor((Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient move(String key, int destdb, Handler<AsyncResult<Long>> handler) {
        this.delegate.move(key, destdb, handler);
        return this;
    }

    public Single<Long> rxMove(String key, int destdb) {
        return new AsyncResultSingle(handler -> this.move(key, destdb, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.delegate.mset(keyvals, handler);
        return this;
    }

    public Single<String> rxMset(JsonObject keyvals) {
        return new AsyncResultSingle(handler -> this.mset(keyvals, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient msetnx(JsonObject keyvals, Handler<AsyncResult<Long>> handler) {
        this.delegate.msetnx(keyvals, handler);
        return this;
    }

    public Single<Long> rxMsetnx(JsonObject keyvals) {
        return new AsyncResultSingle(handler -> this.msetnx(keyvals, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient object(String key, ObjectCmd cmd, Handler<AsyncResult<Void>> handler) {
        this.delegate.object(key, cmd, handler);
        return this;
    }

    public Completable rxObject(String key, ObjectCmd cmd) {
        return new AsyncResultCompletable(handler -> this.object(key, cmd, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient persist(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.persist(key, handler);
        return this;
    }

    public Single<Long> rxPersist(String key) {
        return new AsyncResultSingle(handler -> this.persist(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient pexpire(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.delegate.pexpire(key, millis, handler);
        return this;
    }

    public Single<Long> rxPexpire(String key, long millis) {
        return new AsyncResultSingle(handler -> this.pexpire(key, millis, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient pexpireat(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.delegate.pexpireat(key, millis, handler);
        return this;
    }

    public Single<Long> rxPexpireat(String key, long millis) {
        return new AsyncResultSingle(handler -> this.pexpireat(key, millis, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient pfadd(String key, String element, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfadd(key, element, handler);
        return this;
    }

    public Single<Long> rxPfadd(String key, String element) {
        return new AsyncResultSingle(handler -> this.pfadd(key, element, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient pfaddMany(String key, List<String> elements, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfaddMany(key, elements, handler);
        return this;
    }

    public Single<Long> rxPfaddMany(String key, List<String> elements) {
        return new AsyncResultSingle(handler -> this.pfaddMany(key, elements, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient pfcount(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfcount(key, handler);
        return this;
    }

    public Single<Long> rxPfcount(String key) {
        return new AsyncResultSingle(handler -> this.pfcount(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient pfcountMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfcountMany(keys, handler);
        return this;
    }

    public Single<Long> rxPfcountMany(List<String> keys) {
        return new AsyncResultSingle(handler -> this.pfcountMany(keys, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.pfmerge(destkey, keys, handler);
        return this;
    }

    public Single<String> rxPfmerge(String destkey, List<String> keys) {
        return new AsyncResultSingle(handler -> this.pfmerge(destkey, keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient ping(Handler<AsyncResult<String>> handler) {
        this.delegate.ping(handler);
        return this;
    }

    public Single<String> rxPing() {
        return new AsyncResultSingle(handler -> this.ping((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient psetex(String key, long millis, String value, Handler<AsyncResult<Void>> handler) {
        this.delegate.psetex(key, millis, value, handler);
        return this;
    }

    public Completable rxPsetex(String key, long millis, String value) {
        return new AsyncResultCompletable(handler -> this.psetex(key, millis, value, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient psubscribe(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.psubscribe(pattern, handler);
        return this;
    }

    public Single<JsonArray> rxPsubscribe(String pattern) {
        return new AsyncResultSingle(handler -> this.psubscribe(pattern, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient psubscribeMany(List<String> patterns, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.psubscribeMany(patterns, handler);
        return this;
    }

    public Single<JsonArray> rxPsubscribeMany(List<String> patterns) {
        return new AsyncResultSingle(handler -> this.psubscribeMany(patterns, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient pubsubChannels(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.pubsubChannels(pattern, handler);
        return this;
    }

    public Single<JsonArray> rxPubsubChannels(String pattern) {
        return new AsyncResultSingle(handler -> this.pubsubChannels(pattern, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient pubsubNumsub(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.pubsubNumsub(channels, handler);
        return this;
    }

    public Single<JsonArray> rxPubsubNumsub(List<String> channels) {
        return new AsyncResultSingle(handler -> this.pubsubNumsub(channels, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient pubsubNumpat(Handler<AsyncResult<Long>> handler) {
        this.delegate.pubsubNumpat(handler);
        return this;
    }

    public Single<Long> rxPubsubNumpat() {
        return new AsyncResultSingle(handler -> this.pubsubNumpat((Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient pttl(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.pttl(key, handler);
        return this;
    }

    public Single<Long> rxPttl(String key) {
        return new AsyncResultSingle(handler -> this.pttl(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient publish(String channel, String message, Handler<AsyncResult<Long>> handler) {
        this.delegate.publish(channel, message, handler);
        return this;
    }

    public Single<Long> rxPublish(String channel, String message) {
        return new AsyncResultSingle(handler -> this.publish(channel, message, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient punsubscribe(List<String> patterns, Handler<AsyncResult<Void>> handler) {
        this.delegate.punsubscribe(patterns, handler);
        return this;
    }

    public Completable rxPunsubscribe(List<String> patterns) {
        return new AsyncResultCompletable(handler -> this.punsubscribe(patterns, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient randomkey(Handler<AsyncResult<String>> handler) {
        this.delegate.randomkey(handler);
        return this;
    }

    public Single<String> rxRandomkey() {
        return new AsyncResultSingle(handler -> this.randomkey((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rename(key, newkey, handler);
        return this;
    }

    public Single<String> rxRename(String key, String newkey) {
        return new AsyncResultSingle(handler -> this.rename(key, newkey, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient renamenx(String key, String newkey, Handler<AsyncResult<Long>> handler) {
        this.delegate.renamenx(key, newkey, handler);
        return this;
    }

    public Single<Long> rxRenamenx(String key, String newkey) {
        return new AsyncResultSingle(handler -> this.renamenx(key, newkey, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
        this.delegate.restore(key, millis, serialized, handler);
        return this;
    }

    public Single<String> rxRestore(String key, long millis, String serialized) {
        return new AsyncResultSingle(handler -> this.restore(key, millis, serialized, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient role(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.role(handler);
        return this;
    }

    public Single<JsonArray> rxRole() {
        return new AsyncResultSingle(handler -> this.role((Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient rpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.rpop(key, handler);
        return this;
    }

    public Single<String> rxRpop(String key) {
        return new AsyncResultSingle(handler -> this.rpop(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rpoplpush(key, destkey, handler);
        return this;
    }

    public Single<String> rxRpoplpush(String key, String destkey) {
        return new AsyncResultSingle(handler -> this.rpoplpush(key, destkey, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient rpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.delegate.rpushMany(key, values, handler);
        return this;
    }

    public Single<Long> rxRpushMany(String key, List<String> values) {
        return new AsyncResultSingle(handler -> this.rpushMany(key, values, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient rpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.rpush(key, value, handler);
        return this;
    }

    public Single<Long> rxRpush(String key, String value) {
        return new AsyncResultSingle(handler -> this.rpush(key, value, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient rpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.rpushx(key, value, handler);
        return this;
    }

    public Single<Long> rxRpushx(String key, String value) {
        return new AsyncResultSingle(handler -> this.rpushx(key, value, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient sadd(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.sadd(key, member, handler);
        return this;
    }

    public Single<Long> rxSadd(String key, String member) {
        return new AsyncResultSingle(handler -> this.sadd(key, member, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient saddMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.saddMany(key, members, handler);
        return this;
    }

    public Single<Long> rxSaddMany(String key, List<String> members) {
        return new AsyncResultSingle(handler -> this.saddMany(key, members, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient save(Handler<AsyncResult<String>> handler) {
        this.delegate.save(handler);
        return this;
    }

    public Single<String> rxSave() {
        return new AsyncResultSingle(handler -> this.save((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient scard(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.scard(key, handler);
        return this;
    }

    public Single<Long> rxScard(String key) {
        return new AsyncResultSingle(handler -> this.scard(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient scriptExists(String script, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.scriptExists(script, handler);
        return this;
    }

    public Single<JsonArray> rxScriptExists(String script) {
        return new AsyncResultSingle(handler -> this.scriptExists(script, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient scriptExistsMany(List<String> scripts, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.scriptExistsMany(scripts, handler);
        return this;
    }

    public Single<JsonArray> rxScriptExistsMany(List<String> scripts) {
        return new AsyncResultSingle(handler -> this.scriptExistsMany(scripts, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient scriptFlush(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptFlush(handler);
        return this;
    }

    public Single<String> rxScriptFlush() {
        return new AsyncResultSingle(handler -> this.scriptFlush((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient scriptKill(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptKill(handler);
        return this;
    }

    public Single<String> rxScriptKill() {
        return new AsyncResultSingle(handler -> this.scriptKill((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient scriptLoad(String script, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptLoad(script, handler);
        return this;
    }

    public Single<String> rxScriptLoad(String script) {
        return new AsyncResultSingle(handler -> this.scriptLoad(script, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sdiff(key, cmpkeys, handler);
        return this;
    }

    public Single<JsonArray> rxSdiff(String key, List<String> cmpkeys) {
        return new AsyncResultSingle(handler -> this.sdiff(key, cmpkeys, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<Long>> handler) {
        this.delegate.sdiffstore(destkey, key, cmpkeys, handler);
        return this;
    }

    public Single<Long> rxSdiffstore(String destkey, String key, List<String> cmpkeys) {
        return new AsyncResultSingle(handler -> this.sdiffstore(destkey, key, cmpkeys, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient select(int dbindex, Handler<AsyncResult<String>> handler) {
        this.delegate.select(dbindex, handler);
        return this;
    }

    public Single<String> rxSelect(int dbindex) {
        return new AsyncResultSingle(handler -> this.select(dbindex, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient set(String key, String value, Handler<AsyncResult<Void>> handler) {
        this.delegate.set(key, value, handler);
        return this;
    }

    public Completable rxSet(String key, String value) {
        return new AsyncResultCompletable(handler -> this.set(key, value, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.setWithOptions(key, value, options, handler);
        return this;
    }

    public Single<String> rxSetWithOptions(String key, String value, SetOptions options) {
        return new AsyncResultSingle(handler -> this.setWithOptions(key, value, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient setBinary(String key, Buffer value, Handler<AsyncResult<Void>> handler) {
        this.delegate.setBinary(key, value.getDelegate(), handler);
        return this;
    }

    public Completable rxSetBinary(String key, Buffer value) {
        return new AsyncResultCompletable(handler -> this.setBinary(key, value, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient setBinaryWithOptions(String key, Buffer value, SetOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.setBinaryWithOptions(key, value.getDelegate(), options, handler);
        return this;
    }

    public Completable rxSetBinaryWithOptions(String key, Buffer value, SetOptions options) {
        return new AsyncResultCompletable(handler -> this.setBinaryWithOptions(key, value, options, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient setbit(String key, long offset, int bit, Handler<AsyncResult<Long>> handler) {
        this.delegate.setbit(key, offset, bit, handler);
        return this;
    }

    public Single<Long> rxSetbit(String key, long offset, int bit) {
        return new AsyncResultSingle(handler -> this.setbit(key, offset, bit, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setex(key, seconds, value, handler);
        return this;
    }

    public Single<String> rxSetex(String key, long seconds, String value) {
        return new AsyncResultSingle(handler -> this.setex(key, seconds, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient setnx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.setnx(key, value, handler);
        return this;
    }

    public Single<Long> rxSetnx(String key, String value) {
        return new AsyncResultSingle(handler -> this.setnx(key, value, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient setrange(String key, int offset, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.setrange(key, offset, value, handler);
        return this;
    }

    public Single<Long> rxSetrange(String key, int offset, String value) {
        return new AsyncResultSingle(handler -> this.setrange(key, offset, value, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient sinter(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sinter(keys, handler);
        return this;
    }

    public Single<JsonArray> rxSinter(List<String> keys) {
        return new AsyncResultSingle(handler -> this.sinter(keys, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient sinterstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.sinterstore(destkey, keys, handler);
        return this;
    }

    public Single<Long> rxSinterstore(String destkey, List<String> keys) {
        return new AsyncResultSingle(handler -> this.sinterstore(destkey, keys, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient sismember(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.sismember(key, member, handler);
        return this;
    }

    public Single<Long> rxSismember(String key, String member) {
        return new AsyncResultSingle(handler -> this.sismember(key, member, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
        this.delegate.slaveof(host, port, handler);
        return this;
    }

    public Single<String> rxSlaveof(String host, int port) {
        return new AsyncResultSingle(handler -> this.slaveof(host, port, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient slaveofNoone(Handler<AsyncResult<String>> handler) {
        this.delegate.slaveofNoone(handler);
        return this;
    }

    public Single<String> rxSlaveofNoone() {
        return new AsyncResultSingle(handler -> this.slaveofNoone((Handler<AsyncResult<String>>)handler));
    }

    public RedisClient slowlogGet(int limit, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.slowlogGet(limit, handler);
        return this;
    }

    public Single<JsonArray> rxSlowlogGet(int limit) {
        return new AsyncResultSingle(handler -> this.slowlogGet(limit, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient slowlogLen(Handler<AsyncResult<Long>> handler) {
        this.delegate.slowlogLen(handler);
        return this;
    }

    public Single<Long> rxSlowlogLen() {
        return new AsyncResultSingle(handler -> this.slowlogLen((Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient slowlogReset(Handler<AsyncResult<Void>> handler) {
        this.delegate.slowlogReset(handler);
        return this;
    }

    public Completable rxSlowlogReset() {
        return new AsyncResultCompletable(handler -> this.slowlogReset((Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.smembers(key, handler);
        return this;
    }

    public Single<JsonArray> rxSmembers(String key) {
        return new AsyncResultSingle(handler -> this.smembers(key, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient smove(String key, String destkey, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.smove(key, destkey, member, handler);
        return this;
    }

    public Single<Long> rxSmove(String key, String destkey, String member) {
        return new AsyncResultSingle(handler -> this.smove(key, destkey, member, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient sort(String key, SortOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sort(key, options, handler);
        return this;
    }

    public Single<JsonArray> rxSort(String key, SortOptions options) {
        return new AsyncResultSingle(handler -> this.sort(key, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient spop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.spop(key, handler);
        return this;
    }

    public Single<String> rxSpop(String key) {
        return new AsyncResultSingle(handler -> this.spop(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient spopMany(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.spopMany(key, count, handler);
        return this;
    }

    public Single<JsonArray> rxSpopMany(String key, int count) {
        return new AsyncResultSingle(handler -> this.spopMany(key, count, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient srandmember(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.srandmember(key, handler);
        return this;
    }

    public Single<String> rxSrandmember(String key) {
        return new AsyncResultSingle(handler -> this.srandmember(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient srandmemberCount(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.srandmemberCount(key, count, handler);
        return this;
    }

    public Single<JsonArray> rxSrandmemberCount(String key, int count) {
        return new AsyncResultSingle(handler -> this.srandmemberCount(key, count, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient srem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.srem(key, member, handler);
        return this;
    }

    public Single<Long> rxSrem(String key, String member) {
        return new AsyncResultSingle(handler -> this.srem(key, member, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient sremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.sremMany(key, members, handler);
        return this;
    }

    public Single<Long> rxSremMany(String key, List<String> members) {
        return new AsyncResultSingle(handler -> this.sremMany(key, members, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient strlen(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.strlen(key, handler);
        return this;
    }

    public Single<Long> rxStrlen(String key) {
        return new AsyncResultSingle(handler -> this.strlen(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient subscribe(String channel, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.subscribe(channel, handler);
        return this;
    }

    public Single<JsonArray> rxSubscribe(String channel) {
        return new AsyncResultSingle(handler -> this.subscribe(channel, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient subscribeMany(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.subscribeMany(channels, handler);
        return this;
    }

    public Single<JsonArray> rxSubscribeMany(List<String> channels) {
        return new AsyncResultSingle(handler -> this.subscribeMany(channels, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient sunion(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sunion(keys, handler);
        return this;
    }

    public Single<JsonArray> rxSunion(List<String> keys) {
        return new AsyncResultSingle(handler -> this.sunion(keys, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient sunionstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.sunionstore(destkey, keys, handler);
        return this;
    }

    public Single<Long> rxSunionstore(String destkey, List<String> keys) {
        return new AsyncResultSingle(handler -> this.sunionstore(destkey, keys, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient sync(Handler<AsyncResult<Void>> handler) {
        this.delegate.sync(handler);
        return this;
    }

    public Completable rxSync() {
        return new AsyncResultCompletable(handler -> this.sync((Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient time(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.time(handler);
        return this;
    }

    public Single<JsonArray> rxTime() {
        return new AsyncResultSingle(handler -> this.time((Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisTransaction transaction() {
        RedisTransaction ret = RedisTransaction.newInstance(this.delegate.transaction());
        return ret;
    }

    public RedisClient ttl(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.ttl(key, handler);
        return this;
    }

    public Single<Long> rxTtl(String key) {
        return new AsyncResultSingle(handler -> this.ttl(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient type(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.type(key, handler);
        return this;
    }

    public Single<String> rxType(String key) {
        return new AsyncResultSingle(handler -> this.type(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient unsubscribe(List<String> channels, Handler<AsyncResult<Void>> handler) {
        this.delegate.unsubscribe(channels, handler);
        return this;
    }

    public Completable rxUnsubscribe(List<String> channels) {
        return new AsyncResultCompletable(handler -> this.unsubscribe(channels, (Handler<AsyncResult<Void>>)handler));
    }

    public RedisClient wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
        this.delegate.wait(numSlaves, timeout, handler);
        return this;
    }

    public Single<String> rxWait(long numSlaves, long timeout) {
        return new AsyncResultSingle(handler -> this.wait(numSlaves, timeout, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient zadd(String key, double score, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zadd(key, score, member, handler);
        return this;
    }

    public Single<Long> rxZadd(String key, double score, String member) {
        return new AsyncResultSingle(handler -> this.zadd(key, score, member, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.zaddMany(key, members, handler);
        return this;
    }

    public Single<Long> rxZaddMany(String key, Map<String, Double> members) {
        return new AsyncResultSingle(handler -> this.zaddMany(key, members, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zcard(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.zcard(key, handler);
        return this;
    }

    public Single<Long> rxZcard(String key) {
        return new AsyncResultSingle(handler -> this.zcard(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zcount(String key, double min, double max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zcount(key, min, max, handler);
        return this;
    }

    public Single<Long> rxZcount(String key, double min, double max) {
        return new AsyncResultSingle(handler -> this.zcount(key, min, max, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zincrby(key, increment, member, handler);
        return this;
    }

    public Single<String> rxZincrby(String key, double increment, String member) {
        return new AsyncResultSingle(handler -> this.zincrby(key, increment, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zinterstore(destkey, sets, options, handler);
        return this;
    }

    public Single<Long> rxZinterstore(String destkey, List<String> sets, AggregateOptions options) {
        return new AsyncResultSingle(handler -> this.zinterstore(destkey, sets, options, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zinterstoreWeighed(destkey, sets, options, handler);
        return this;
    }

    public Single<Long> rxZinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options) {
        return new AsyncResultSingle(handler -> this.zinterstoreWeighed(destkey, sets, options, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zlexcount(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zlexcount(key, min, max, handler);
        return this;
    }

    public Single<Long> rxZlexcount(String key, String min, String max) {
        return new AsyncResultSingle(handler -> this.zlexcount(key, min, max, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zrange(String key, long start, long stop, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrange(key, start, stop, handler);
        return this;
    }

    public Single<JsonArray> rxZrange(String key, long start, long stop) {
        return new AsyncResultSingle(handler -> this.zrange(key, start, stop, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrangeWithOptions(key, start, stop, options, handler);
        return this;
    }

    public Single<JsonArray> rxZrangeWithOptions(String key, long start, long stop, RangeOptions options) {
        return new AsyncResultSingle(handler -> this.zrangeWithOptions(key, start, stop, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrangebylex(key, min, max, options, handler);
        return this;
    }

    public Single<JsonArray> rxZrangebylex(String key, String min, String max, LimitOptions options) {
        return new AsyncResultSingle(handler -> this.zrangebylex(key, min, max, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrangebyscore(key, min, max, options, handler);
        return this;
    }

    public Single<JsonArray> rxZrangebyscore(String key, String min, String max, RangeLimitOptions options) {
        return new AsyncResultSingle(handler -> this.zrangebyscore(key, min, max, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient zrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zrank(key, member, handler);
        return this;
    }

    public Single<Long> rxZrank(String key, String member) {
        return new AsyncResultSingle(handler -> this.zrank(key, member, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zrem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zrem(key, member, handler);
        return this;
    }

    public Single<Long> rxZrem(String key, String member) {
        return new AsyncResultSingle(handler -> this.zrem(key, member, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremMany(key, members, handler);
        return this;
    }

    public Single<Long> rxZremMany(String key, List<String> members) {
        return new AsyncResultSingle(handler -> this.zremMany(key, members, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zremrangebylex(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremrangebylex(key, min, max, handler);
        return this;
    }

    public Single<Long> rxZremrangebylex(String key, String min, String max) {
        return new AsyncResultSingle(handler -> this.zremrangebylex(key, min, max, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremrangebyrank(key, start, stop, handler);
        return this;
    }

    public Single<Long> rxZremrangebyrank(String key, long start, long stop) {
        return new AsyncResultSingle(handler -> this.zremrangebyrank(key, start, stop, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zremrangebyscore(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremrangebyscore(key, min, max, handler);
        return this;
    }

    public Single<Long> rxZremrangebyscore(String key, String min, String max) {
        return new AsyncResultSingle(handler -> this.zremrangebyscore(key, min, max, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrevrange(key, start, stop, options, handler);
        return this;
    }

    public Single<JsonArray> rxZrevrange(String key, long start, long stop, RangeOptions options) {
        return new AsyncResultSingle(handler -> this.zrevrange(key, start, stop, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrevrangebylex(key, max, min, options, handler);
        return this;
    }

    public Single<JsonArray> rxZrevrangebylex(String key, String max, String min, LimitOptions options) {
        return new AsyncResultSingle(handler -> this.zrevrangebylex(key, max, min, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrevrangebyscore(key, max, min, options, handler);
        return this;
    }

    public Single<JsonArray> rxZrevrangebyscore(String key, String max, String min, RangeLimitOptions options) {
        return new AsyncResultSingle(handler -> this.zrevrangebyscore(key, max, min, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient zrevrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zrevrank(key, member, handler);
        return this;
    }

    public Single<Long> rxZrevrank(String key, String member) {
        return new AsyncResultSingle(handler -> this.zrevrank(key, member, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zscore(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zscore(key, member, handler);
        return this;
    }

    public Single<String> rxZscore(String key, String member) {
        return new AsyncResultSingle(handler -> this.zscore(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zunionstore(destkey, sets, options, handler);
        return this;
    }

    public Single<Long> rxZunionstore(String destkey, List<String> sets, AggregateOptions options) {
        return new AsyncResultSingle(handler -> this.zunionstore(destkey, sets, options, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient zunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zunionstoreWeighed(key, sets, options, handler);
        return this;
    }

    public Single<Long> rxZunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options) {
        return new AsyncResultSingle(handler -> this.zunionstoreWeighed(key, sets, options, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient scan(String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.scan(cursor, options, handler);
        return this;
    }

    public Single<JsonArray> rxScan(String cursor, ScanOptions options) {
        return new AsyncResultSingle(handler -> this.scan(cursor, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sscan(key, cursor, options, handler);
        return this;
    }

    public Single<JsonArray> rxSscan(String key, String cursor, ScanOptions options) {
        return new AsyncResultSingle(handler -> this.sscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hscan(key, cursor, options, handler);
        return this;
    }

    public Single<JsonArray> rxHscan(String key, String cursor, ScanOptions options) {
        return new AsyncResultSingle(handler -> this.hscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zscan(key, cursor, options, handler);
        return this;
    }

    public Single<JsonArray> rxZscan(String key, String cursor, ScanOptions options) {
        return new AsyncResultSingle(handler -> this.zscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.geoadd(key, longitude, latitude, member, handler);
        return this;
    }

    public Single<Long> rxGeoadd(String key, double longitude, double latitude, String member) {
        return new AsyncResultSingle(handler -> this.geoadd(key, longitude, latitude, member, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.geoaddMany(key, members, handler);
        return this;
    }

    public Single<Long> rxGeoaddMany(String key, List<GeoMember> members) {
        return new AsyncResultSingle(handler -> this.geoaddMany(key, members, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient geohash(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geohash(key, member, handler);
        return this;
    }

    public Single<JsonArray> rxGeohash(String key, String member) {
        return new AsyncResultSingle(handler -> this.geohash(key, member, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient geohashMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geohashMany(key, members, handler);
        return this;
    }

    public Single<JsonArray> rxGeohashMany(String key, List<String> members) {
        return new AsyncResultSingle(handler -> this.geohashMany(key, members, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient geopos(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geopos(key, member, handler);
        return this;
    }

    public Single<JsonArray> rxGeopos(String key, String member) {
        return new AsyncResultSingle(handler -> this.geopos(key, member, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient geoposMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geoposMany(key, members, handler);
        return this;
    }

    public Single<JsonArray> rxGeoposMany(String key, List<String> members) {
        return new AsyncResultSingle(handler -> this.geoposMany(key, members, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
        this.delegate.geodist(key, member1, member2, handler);
        return this;
    }

    public Single<String> rxGeodist(String key, String member1, String member2) {
        return new AsyncResultSingle(handler -> this.geodist(key, member1, member2, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.geodistWithUnit(key, member1, member2, unit, handler);
        return this;
    }

    public Single<String> rxGeodistWithUnit(String key, String member1, String member2, GeoUnit unit) {
        return new AsyncResultSingle(handler -> this.geodistWithUnit(key, member1, member2, unit, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadius(key, longitude, latitude, radius, unit, handler);
        return this;
    }

    public Single<JsonArray> rxGeoradius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return new AsyncResultSingle(handler -> this.georadius(key, longitude, latitude, radius, unit, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadiusWithOptions(key, longitude, latitude, radius, unit, options, handler);
        return this;
    }

    public Single<JsonArray> rxGeoradiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return new AsyncResultSingle(handler -> this.georadiusWithOptions(key, longitude, latitude, radius, unit, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadiusbymember(key, member, radius, unit, handler);
        return this;
    }

    public Single<JsonArray> rxGeoradiusbymember(String key, String member, double radius, GeoUnit unit) {
        return new AsyncResultSingle(handler -> this.georadiusbymember(key, member, radius, unit, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadiusbymemberWithOptions(key, member, radius, unit, options, handler);
        return this;
    }

    public Single<JsonArray> rxGeoradiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return new AsyncResultSingle(handler -> this.georadiusbymemberWithOptions(key, member, radius, unit, options, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient clientReply(ClientReplyOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.clientReply(options, handler);
        return this;
    }

    public Single<String> rxClientReply(ClientReplyOptions options) {
        return new AsyncResultSingle(handler -> this.clientReply(options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient hstrlen(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.delegate.hstrlen(key, field, handler);
        return this;
    }

    public Single<Long> rxHstrlen(String key, String field) {
        return new AsyncResultSingle(handler -> this.hstrlen(key, field, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient touch(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.touch(key, handler);
        return this;
    }

    public Single<Long> rxTouch(String key) {
        return new AsyncResultSingle(handler -> this.touch(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient touchMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.touchMany(keys, handler);
        return this;
    }

    public Single<Long> rxTouchMany(List<String> keys) {
        return new AsyncResultSingle(handler -> this.touchMany(keys, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient scriptDebug(ScriptDebugOptions scriptDebugOptions, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptDebug(scriptDebugOptions, handler);
        return this;
    }

    public Single<String> rxScriptDebug(ScriptDebugOptions scriptDebugOptions) {
        return new AsyncResultSingle(handler -> this.scriptDebug(scriptDebugOptions, (Handler<AsyncResult<String>>)handler));
    }

    public RedisClient bitfield(String key, BitFieldOptions bitFieldOptions, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.bitfield(key, bitFieldOptions, handler);
        return this;
    }

    public Single<JsonArray> rxBitfield(String key, BitFieldOptions bitFieldOptions) {
        return new AsyncResultSingle(handler -> this.bitfield(key, bitFieldOptions, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient bitfieldWithOverflow(String key, BitFieldOptions commands, BitFieldOverflowOptions overflow, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.bitfieldWithOverflow(key, commands, overflow, handler);
        return this;
    }

    public Single<JsonArray> rxBitfieldWithOverflow(String key, BitFieldOptions commands, BitFieldOverflowOptions overflow) {
        return new AsyncResultSingle(handler -> this.bitfieldWithOverflow(key, commands, overflow, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisClient unlink(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.unlink(key, handler);
        return this;
    }

    public Single<Long> rxUnlink(String key) {
        return new AsyncResultSingle(handler -> this.unlink(key, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient unlinkMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.unlinkMany(keys, handler);
        return this;
    }

    public Single<Long> rxUnlinkMany(List<String> keys) {
        return new AsyncResultSingle(handler -> this.unlinkMany(keys, (Handler<AsyncResult<Long>>)handler));
    }

    public RedisClient swapdb(int index1, int index2, Handler<AsyncResult<String>> handler) {
        this.delegate.swapdb(index1, index2, handler);
        return this;
    }

    public Single<String> rxSwapdb(int index1, int index2) {
        return new AsyncResultSingle(handler -> this.swapdb(index1, index2, (Handler<AsyncResult<String>>)handler));
    }

    public static RedisClient newInstance(io.vertx.redis.RedisClient arg) {
        return arg != null ? new RedisClient(arg) : null;
    }
}

