/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.impl.BaseRedisClient;
import io.vertx.redis.impl.Command;
import io.vertx.redis.impl.RedisSentinelCommand;
import io.vertx.redis.impl.ResponseTransform;
import io.vertx.redis.sentinel.RedisSentinel;
import java.util.List;

public abstract class AbstractRedisSentinelClient
extends BaseRedisClient<RedisSentinelCommand>
implements RedisSentinel {
    AbstractRedisSentinelClient(Vertx vertx, RedisOptions config) {
        super(vertx, config);
    }

    private ResponseTransform getResponseTransformFor(RedisSentinelCommand command) {
        if (command == RedisSentinelCommand.INFO) {
            return ResponseTransform.INFO;
        }
        return ResponseTransform.NONE;
    }

    @Override
    final <T> void send(RedisSentinelCommand command, List<?> redisArgs, Class<T> returnType, boolean binary, Handler<AsyncResult<T>> resultHandler) {
        Command<T> cmd = new Command<T>(Vertx.currentContext(), command, redisArgs, binary ? this.binaryCharset : this.charset, this.getResponseTransformFor(command), returnType).handler(resultHandler);
        switch (command) {
            case PSUBSCRIBE: {
                cmd.setExpectedReplies(redisArgs.size());
                for (Object obj : redisArgs) {
                    String pattern = (String)obj;
                    String vertxChannel = this.baseAddress + "." + pattern;
                    this.subscriptions.registerPatternSubscribeHandler(pattern, (pattern1, replyData) -> {
                        JsonObject replyMessage = new JsonObject();
                        replyMessage.put("status", "ok");
                        JsonObject message = new JsonObject();
                        message.put("pattern", pattern1);
                        message.put("channel", replyData[2].asType(String.class, this.encoding));
                        message.put("message", replyData[3].asType(String.class, this.encoding));
                        replyMessage.put("value", message);
                        this.eb.send(vertxChannel, (Object)replyMessage);
                    });
                }
                this.pubsub.send(cmd);
                break;
            }
            case SUBSCRIBE: {
                cmd.setExpectedReplies(redisArgs.size());
                for (Object obj : redisArgs) {
                    String channel = (String)obj;
                    String vertxChannel = this.baseAddress + "." + channel;
                    this.subscriptions.registerChannelSubscribeHandler(channel, (channel1, replyData) -> {
                        JsonObject replyMessage = new JsonObject();
                        replyMessage.put("status", "ok");
                        JsonObject message = new JsonObject();
                        message.put("channel", channel1);
                        message.put("message", replyData[2].asType(String.class, this.encoding));
                        replyMessage.put("value", message);
                        this.eb.send(vertxChannel, (Object)replyMessage);
                    });
                }
                this.pubsub.send(cmd);
                break;
            }
            case PUNSUBSCRIBE: {
                if (redisArgs == null || redisArgs.size() == 0) {
                    cmd.setExpectedReplies(this.subscriptions.patternSize());
                    this.subscriptions.unregisterPatternSubscribeHandler(null);
                } else {
                    cmd.setExpectedReplies(redisArgs.size());
                    for (Object obj : redisArgs) {
                        String pattern = (String)obj;
                        this.subscriptions.unregisterPatternSubscribeHandler(pattern);
                    }
                }
                this.pubsub.send(cmd);
                break;
            }
            case UNSUBSCRIBE: {
                if (redisArgs == null || redisArgs.size() == 0) {
                    cmd.setExpectedReplies(this.subscriptions.channelSize());
                    this.subscriptions.unregisterChannelSubscribeHandler(null);
                } else {
                    cmd.setExpectedReplies(redisArgs.size());
                    for (Object obj : redisArgs) {
                        String channel = (String)obj;
                        this.subscriptions.unregisterChannelSubscribeHandler(channel);
                    }
                }
                this.pubsub.send(cmd);
                break;
            }
            case QUIT: {
                this.redis.send(cmd);
                this.pubsub.send(cmd);
                break;
            }
            default: {
                this.redis.send(cmd);
            }
        }
    }
}

