/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.impl.RedisConnection;
import io.vertx.redis.impl.RedisSubscriptions;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

abstract class BaseRedisClient<C> {
    final EventBus eb;
    final RedisSubscriptions subscriptions;
    final String encoding;
    final Charset charset;
    final Charset binaryCharset;
    final String baseAddress;
    final RedisConnection redis;
    final RedisConnection pubsub;

    BaseRedisClient(Vertx vertx, RedisOptions config) {
        this.eb = vertx.eventBus();
        this.encoding = config.getEncoding();
        this.charset = Charset.forName(this.encoding);
        this.binaryCharset = Charset.forName("iso-8859-1");
        this.baseAddress = config.getAddress();
        this.subscriptions = new RedisSubscriptions(vertx);
        this.redis = new RedisConnection(vertx, config, null);
        this.pubsub = new RedisConnection(vertx, config, this.subscriptions);
    }

    public synchronized void close(Handler<AsyncResult<Void>> handler) {
        AtomicInteger cnt = new AtomicInteger(0);
        Handler cb = v -> {
            if (cnt.incrementAndGet() == 2) {
                handler.handle((Object)Future.succeededFuture());
            }
        };
        this.redis.disconnect((Handler<AsyncResult<Void>>)cb);
        this.pubsub.disconnect((Handler<AsyncResult<Void>>)cb);
    }

    final void sendString(C command, List<?> args, Handler<AsyncResult<String>> resultHandler) {
        this.send(command, args, String.class, false, resultHandler);
    }

    final void sendLong(C command, List<?> args, Handler<AsyncResult<Long>> resultHandler) {
        this.send(command, args, Long.class, false, resultHandler);
    }

    final void sendVoid(C command, List<?> args, Handler<AsyncResult<Void>> resultHandler) {
        this.send(command, args, Void.class, false, resultHandler);
    }

    final void sendJsonArray(C command, List<?> args, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.send(command, args, JsonArray.class, false, resultHandler);
    }

    final void sendJsonObject(C command, List<?> args, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.send(command, args, JsonObject.class, false, resultHandler);
    }

    abstract <R> void send(C var1, List<?> var2, Class<R> var3, boolean var4, Handler<AsyncResult<R>> var5);
}

