/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.impl.MessageHandler;
import io.vertx.redis.impl.Reply;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RedisSubscriptions {
    private static final Logger log = LoggerFactory.getLogger(RedisSubscriptions.class);
    private final Vertx vertx;
    private final Map<String, Subscription> channelSubscribers = new ConcurrentHashMap<String, Subscription>();
    private final Map<String, Subscription> patternSubscribers = new ConcurrentHashMap<String, Subscription>();

    public RedisSubscriptions(Vertx vertx) {
        this.vertx = vertx;
    }

    public void registerChannelSubscribeHandler(String channel, MessageHandler messageHandler) {
        this.channelSubscribers.put(channel, new Subscription(messageHandler));
    }

    public void registerPatternSubscribeHandler(String pattern, MessageHandler messageHandler) {
        this.patternSubscribers.put(pattern, new Subscription(messageHandler));
    }

    public void unregisterChannelSubscribeHandler(String channel) {
        if (channel == null) {
            this.channelSubscribers.clear();
        } else {
            this.channelSubscribers.remove(channel);
        }
    }

    public void unregisterPatternSubscribeHandler(String pattern) {
        if (pattern == null) {
            this.patternSubscribers.clear();
        } else {
            this.patternSubscribers.remove(pattern);
        }
    }

    public void handleChannel(String channel, Reply[] replyData) {
        Subscription s = this.channelSubscribers.get(channel);
        if (s != null) {
            s.handle(channel, replyData);
        } else {
            log.warn((Object)"No pub/sub handler waiting for message");
        }
    }

    public void handlePattern(String pattern, Reply[] replyData) {
        Subscription s = this.patternSubscribers.get(pattern);
        if (s != null) {
            s.handle(pattern, replyData);
        } else {
            log.warn((Object)"No pub/sub handler waiting for message");
        }
    }

    public int channelSize() {
        return this.channelSubscribers.size();
    }

    public int patternSize() {
        return this.patternSubscribers.size();
    }

    public Set<String> channelNames() {
        return this.channelSubscribers.keySet();
    }

    public Set<String> patternNames() {
        return this.patternSubscribers.keySet();
    }

    private class Subscription {
        final Context context;
        final MessageHandler handler;

        Subscription(MessageHandler handler) {
            this.context = RedisSubscriptions.this.vertx.getOrCreateContext();
            this.handler = handler;
        }

        void handle(String channelOrPattern, Reply[] replyData) {
            this.context.runOnContext(v -> this.handler.handle(channelOrPattern, replyData));
        }
    }
}

