/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisOptions;
import java.util.ArrayList;

public class RedisOptionsConverter {
    public static void fromJson(JsonObject json, RedisOptions obj) {
        if (json.getValue("address") instanceof String) {
            obj.setAddress((String)json.getValue("address"));
        }
        if (json.getValue("auth") instanceof String) {
            obj.setAuth((String)json.getValue("auth"));
        }
        if (json.getValue("binary") instanceof Boolean) {
            obj.setBinary((Boolean)json.getValue("binary"));
        }
        if (json.getValue("domainSocket") instanceof Boolean) {
            obj.setDomainSocket((Boolean)json.getValue("domainSocket"));
        }
        if (json.getValue("domainSocketAddress") instanceof String) {
            obj.setDomainSocketAddress((String)json.getValue("domainSocketAddress"));
        }
        if (json.getValue("encoding") instanceof String) {
            obj.setEncoding((String)json.getValue("encoding"));
        }
        if (json.getValue("host") instanceof String) {
            obj.setHost((String)json.getValue("host"));
        }
        if (json.getValue("masterName") instanceof String) {
            obj.setMasterName((String)json.getValue("masterName"));
        }
        if (json.getValue("port") instanceof Number) {
            obj.setPort(((Number)json.getValue("port")).intValue());
        }
        if (json.getValue("select") instanceof Number) {
            obj.setSelect(((Number)json.getValue("select")).intValue());
        }
        if (json.getValue("sentinels") instanceof JsonArray) {
            ArrayList<String> list = new ArrayList<String>();
            json.getJsonArray("sentinels").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)item);
                }
            });
            obj.setSentinels(list);
        }
    }

    public static void toJson(RedisOptions obj, JsonObject json) {
        if (obj.getAddress() != null) {
            json.put("address", obj.getAddress());
        }
        if (obj.getAuth() != null) {
            json.put("auth", obj.getAuth());
        }
        json.put("binary", Boolean.valueOf(obj.isBinary()));
        json.put("domainSocket", Boolean.valueOf(obj.isDomainSocket()));
        if (obj.getDomainSocketAddress() != null) {
            json.put("domainSocketAddress", obj.getDomainSocketAddress());
        }
        if (obj.getEncoding() != null) {
            json.put("encoding", obj.getEncoding());
        }
        if (obj.getHost() != null) {
            json.put("host", obj.getHost());
        }
        if (obj.getMasterName() != null) {
            json.put("masterName", obj.getMasterName());
        }
        json.put("port", Integer.valueOf(obj.getPort()));
        if (obj.getSelect() != null) {
            json.put("select", obj.getSelect());
        }
        if (obj.getSentinels() != null) {
            JsonArray array = new JsonArray();
            obj.getSentinels().forEach(item -> array.add(item));
            json.put("sentinels", array);
        }
    }
}

