/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.op;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;

@DataObject
public class KillFilter {
    private String addr;
    private String clientid;
    private Type type;
    private Boolean skipme;

    public KillFilter() {
    }

    public KillFilter(KillFilter copy) {
        this.addr = copy.addr;
        this.clientid = copy.clientid;
        this.type = copy.type;
        this.skipme = copy.skipme;
    }

    public KillFilter(JsonObject json) {
        Boolean bval;
        String value = json.getString("addr");
        if (value != null) {
            this.addr = value;
        }
        if ((value = json.getString("clientid")) != null) {
            this.clientid = value;
        }
        if ((value = json.getString("type")) != null) {
            this.type = Type.valueOf(value.toUpperCase());
        }
        if ((bval = json.getBoolean("skipme")) != null) {
            this.skipme = bval;
        }
    }

    public KillFilter setAddr(String addr) {
        this.addr = addr;
        return this;
    }

    public KillFilter setId(String clientid) {
        this.clientid = clientid;
        return this;
    }

    public KillFilter setType(Type type) {
        this.type = type;
        return this;
    }

    public KillFilter setSkipme(boolean skip) {
        this.skipme = skip;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.addr != null) {
            json.put("addr", this.addr);
        }
        if (this.clientid != null) {
            json.put("clientid", this.clientid);
        }
        if (this.type != null) {
            json.put("type", this.type.name());
        }
        if (this.skipme != null) {
            json.put("skipme", this.skipme);
        }
        return json;
    }

    public JsonArray toJsonArray() {
        JsonArray result = new JsonArray();
        if (this.addr != null) {
            result.add("ADDR");
            result.add(this.addr);
        }
        if (this.clientid != null) {
            result.add("ID");
            result.add(this.clientid);
        }
        if (this.type != null) {
            result.add("TYPE");
            result.add(this.type.name().toLowerCase());
        }
        if (this.skipme != null) {
            result.add("SKIPME");
            result.add(this.skipme != false ? "yes" : "no");
        }
        return result;
    }

    public static enum Type {
        NORMAL,
        SLAVE,
        PUBSUB;

    }
}

