/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisOptions;
import java.util.ArrayList;
import java.util.Map;

public class RedisOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, RedisOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "address": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAddress((String)member.getValue());
                    break;
                }
                case "auth": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAuth((String)member.getValue());
                    break;
                }
                case "binary": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setBinary((Boolean)member.getValue());
                    break;
                }
                case "domainSocket": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDomainSocket((Boolean)member.getValue());
                    break;
                }
                case "domainSocketAddress": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDomainSocketAddress((String)member.getValue());
                    break;
                }
                case "encoding": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setEncoding((String)member.getValue());
                    break;
                }
                case "host": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHost((String)member.getValue());
                    break;
                }
                case "masterName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMasterName((String)member.getValue());
                    break;
                }
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "select": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSelect(((Number)member.getValue()).intValue());
                    break;
                }
                case "sentinels": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setSentinels(list);
                }
            }
        }
    }

    public static void toJson(RedisOptions obj, JsonObject json) {
        RedisOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(RedisOptions obj, Map<String, Object> json) {
        if (obj.getAddress() != null) {
            json.put("address", obj.getAddress());
        }
        if (obj.getAuth() != null) {
            json.put("auth", obj.getAuth());
        }
        json.put("binary", obj.isBinary());
        json.put("domainSocket", obj.isDomainSocket());
        if (obj.getDomainSocketAddress() != null) {
            json.put("domainSocketAddress", obj.getDomainSocketAddress());
        }
        if (obj.getEncoding() != null) {
            json.put("encoding", obj.getEncoding());
        }
        if (obj.getHost() != null) {
            json.put("host", obj.getHost());
        }
        if (obj.getMasterName() != null) {
            json.put("masterName", obj.getMasterName());
        }
        json.put("port", obj.getPort());
        if (obj.getSelect() != null) {
            json.put("select", obj.getSelect());
        }
        if (obj.getSentinels() != null) {
            JsonArray array = new JsonArray();
            obj.getSentinels().forEach(item -> array.add(item));
            json.put("sentinels", array);
        }
    }
}

