/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.impl.CompletionImpl;
import io.vertx.ext.unit.impl.Helper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class TestContextImpl
implements TestContext {
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    private final Map<String, Object> attributes;
    private final Handler<Throwable> unhandledFailureHandler;
    private Step current;

    public TestContextImpl(Map<String, Object> attributes, Handler<Throwable> unhandledFailureHandler) {
        this.attributes = attributes;
        this.unhandledFailureHandler = unhandledFailureHandler;
    }

    @Override
    public synchronized <T> T get(String key) {
        return (T)this.attributes.get(key);
    }

    @Override
    public synchronized <T> T put(String key, Object value) {
        if (value != null) {
            return (T)this.attributes.put(key, value);
        }
        return (T)this.attributes.remove(key);
    }

    @Override
    public synchronized <T> T remove(String key) {
        return (T)this.attributes.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Throwable failed, long timeout, Handler<TestContext> test, Handler<Throwable> endHandler) {
        Step step;
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            if (this.current != null) {
                throw new IllegalStateException("Wrong status");
            }
            this.current = step = new Step((Handler<Throwable>)((Handler)err -> {
                if (failed != null) {
                    endHandler.handle((Object)failed);
                } else {
                    endHandler.handle(err);
                }
            }));
        }
        step.run(timeout, (Handler<TestContext>)test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Throwable t) {
        boolean reported;
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            reported = this.current != null && this.current.failed(t);
        }
        if (!reported && this.unhandledFailureHandler != null) {
            this.unhandledFailureHandler.handle((Object)t);
        }
    }

    @Override
    public Async async() {
        return this.async(1);
    }

    @Override
    public Async async(int count) {
        return this.async(count, false);
    }

    @Override
    public Async strictAsync(int count) {
        return this.async(count, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Async async(int count, boolean strict) {
        if (count < 1) {
            throw new IllegalArgumentException("Async completion count must be > 0");
        }
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            if (this.current != null) {
                return this.current.async(count, strict);
            }
            return new AsyncImpl(count, strict);
        }
    }

    @Override
    public TestContext assertNull(Object expected) {
        return this.assertNull(expected, null);
    }

    @Override
    public TestContext assertNull(Object expected, String message) {
        if (expected != null) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected null"));
        }
        return this;
    }

    @Override
    public TestContext assertNotNull(Object expected) {
        return this.assertNotNull(expected, null);
    }

    @Override
    public TestContext assertNotNull(Object expected, String message) {
        if (expected == null) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected not null"));
        }
        return this;
    }

    @Override
    public TestContext assertTrue(boolean condition, String message) {
        if (!condition) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected true"));
        }
        return this;
    }

    @Override
    public TestContext assertTrue(boolean condition) {
        return this.assertTrue(condition, null);
    }

    @Override
    public TestContext assertFalse(boolean condition) {
        return this.assertFalse(condition, null);
    }

    @Override
    public TestContext assertFalse(boolean condition, String message) {
        if (condition) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected false"));
        }
        return this;
    }

    @Override
    public void fail() {
        this.fail((String)null);
    }

    @Override
    public void fail(String message) {
        throw this.reportAssertionError(message != null ? message : "Test failed");
    }

    @Override
    public void fail(Throwable cause) {
        this.failed(cause);
        Helper.uncheckedThrow(cause);
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this::failed;
    }

    @Override
    public TestContext assertEquals(Object expected, Object actual) {
        return this.assertEquals(expected, actual, null);
    }

    @Override
    public TestContext assertEquals(Object expected, Object actual, String message) {
        if (actual == null) {
            if (expected != null) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected " + expected + " got null"));
            }
        } else {
            if (expected == null) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected null instead of " + actual));
            }
            if (!expected.equals(actual)) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Not equals : " + expected + " != " + actual));
            }
        }
        return this;
    }

    @Override
    public TestContext assertInRange(double expected, double actual, double delta) {
        return this.assertInRange(expected, actual, delta, null);
    }

    @Override
    public TestContext assertInRange(double expected, double actual, double delta, String message) {
        if (Double.compare(expected, actual) != 0 && Math.abs(actual - expected) > delta) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected " + actual + " to belong to [" + (expected - delta) + "," + (expected + delta) + "]"));
        }
        return this;
    }

    @Override
    public TestContext assertNotEquals(Object first, Object second, String message) {
        if (first == null) {
            if (second == null) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected null != null"));
            }
        } else if (first.equals(second)) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected different values " + first + " != " + second));
        }
        return this;
    }

    @Override
    public TestContext verify(Handler<Void> block) {
        try {
            block.handle(null);
        }
        catch (Throwable t) {
            this.fail(t);
        }
        return this;
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertSuccess() {
        return this.asyncAssertSuccess(result -> {});
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertSuccess(Handler<T> resultHandler) {
        Async async = this.async();
        return ar -> {
            if (ar.succeeded()) {
                Object result = ar.result();
                try {
                    resultHandler.handle(result);
                    async.complete();
                }
                catch (Throwable e) {
                    this.failed(e);
                }
            } else {
                this.failed(ar.cause());
            }
        };
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertFailure() {
        return this.asyncAssertFailure((Handler<Throwable>)((Handler)cause -> {}));
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertFailure(Handler<Throwable> causeHandler) {
        Async async = this.async();
        return ar -> {
            if (ar.failed()) {
                Throwable result = ar.cause();
                try {
                    causeHandler.handle((Object)result);
                    async.complete();
                }
                catch (Throwable e) {
                    this.failed(e);
                }
            } else {
                this.reportAssertionError("Was expecting a failure instead of of success");
            }
        };
    }

    @Override
    public TestContext assertNotEquals(Object first, Object second) {
        return this.assertNotEquals(first, second, null);
    }

    private AssertionError reportAssertionError(String message) {
        AssertionError err = new AssertionError((Object)message);
        this.failed((Throwable)((Object)err));
        return err;
    }

    private static String formatMessage(String providedMessage, String defaultMessage) {
        return providedMessage == null ? defaultMessage : providedMessage + ". " + defaultMessage;
    }

    class AsyncImpl
    extends CompletionImpl<Void>
    implements Async {
        private final int initialCount;
        private final AtomicInteger current;
        private final boolean strict;

        public AsyncImpl(int initialCount, boolean strict) {
            this.initialCount = initialCount;
            this.strict = strict;
            this.current = new AtomicInteger(initialCount);
        }

        @Override
        public int count() {
            return this.current.get();
        }

        @Override
        public void countDown() {
            int newValue;
            int oldValue;
            do {
                if ((oldValue = this.current.get()) == 0) {
                    newValue = 0;
                    if (!this.strict) continue;
                    String msg = this.initialCount == 1 ? "Countdown invoked more than once" : (this.initialCount == 2 ? "Countdown invoked more than twice" : "Countdown invoked more than " + this.initialCount + " times");
                    throw new IllegalStateException(msg);
                }
                newValue = oldValue - 1;
            } while (!this.current.compareAndSet(oldValue, newValue));
            if (newValue == 0) {
                this.release(null);
            }
        }

        @Override
        public void complete() {
            int value = this.current.getAndSet(0);
            if (value <= 0) {
                throw new IllegalStateException("The Async complete method has been called more than " + this.initialCount + " times, check your test.");
            }
            this.release(null);
        }

        void release(Throwable failure) {
            if (failure != null) {
                this.completable.completeExceptionally(failure);
            } else {
                this.completable.complete(null);
            }
        }
    }

    private class Step {
        private final Handler<Throwable> endHandler;
        private final LinkedList<AsyncImpl> asyncs = new LinkedList();
        private boolean complete;
        private Throwable failure;

        Step(Handler<Throwable> endHandler) {
            this.endHandler = endHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryEnd() {
            Throwable f;
            List<AsyncImpl> copy;
            boolean end = false;
            Step step = this;
            synchronized (step) {
                if ((this.asyncs.isEmpty() || this.failure != null) && !this.complete) {
                    this.complete = true;
                    end = true;
                }
                if (end) {
                    copy = new ArrayList<AsyncImpl>(this.asyncs);
                    this.asyncs.clear();
                    TestContextImpl testContextImpl = TestContextImpl.this;
                    synchronized (testContextImpl) {
                        TestContextImpl.this.current = null;
                    }
                    this.notify();
                } else {
                    copy = Collections.emptyList();
                }
                f = this.failure;
            }
            if (end) {
                for (AsyncImpl a : copy) {
                    a.release(f);
                }
                this.endHandler.handle((Object)f);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean failed(Throwable t) {
            Step step = this;
            synchronized (step) {
                if (this.complete) {
                    return false;
                }
                if (this.failure == null) {
                    this.failure = t;
                }
            }
            this.tryEnd();
            return true;
        }

        private AsyncImpl async(int count, boolean strict) {
            Step step = this;
            synchronized (step) {
                if (!this.complete) {
                    AsyncImpl async = new AsyncImpl(count, strict);
                    if (this.failure == null) {
                        this.asyncs.add(async);
                        async.completable.whenComplete((v, err) -> {
                            Step step = this;
                            synchronized (step) {
                                this.asyncs.remove(async);
                            }
                            this.tryEnd();
                        });
                    }
                    return async;
                }
                throw new IllegalStateException("Test already completed");
            }
        }

        private void run(long timeout, Handler<TestContext> test) {
            if (timeout > 0L) {
                Runnable cancel = () -> {
                    try {
                        Step step = this;
                        synchronized (step) {
                            if (this.complete) {
                                return;
                            }
                            this.wait(timeout);
                            if (this.complete) {
                                return;
                            }
                        }
                        this.failed(new TimeoutException());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                };
                Thread timeoutThread = new Thread(cancel);
                timeoutThread.setName("vert.x-unit-timeout-thread-" + threadCount.incrementAndGet());
                timeoutThread.start();
            }
            AsyncImpl async = this.async(1, false);
            try {
                test.handle((Object)TestContextImpl.this);
                async.complete();
            }
            catch (Throwable t) {
                this.failed(t);
            }
        }
    }
}

