/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.impl.ExecutionContext;
import io.vertx.ext.unit.impl.Result;
import io.vertx.ext.unit.impl.Task;
import io.vertx.ext.unit.impl.TestCaseImpl;
import io.vertx.ext.unit.impl.TestCaseReportImpl;
import io.vertx.ext.unit.impl.TestContextImpl;
import io.vertx.ext.unit.impl.TestContextTask;
import io.vertx.ext.unit.report.TestCaseReport;
import io.vertx.ext.unit.report.TestSuiteReport;
import java.util.HashMap;
import java.util.Map;

class TestSuiteReportImpl
implements TestSuiteReport {
    private final String name;
    private final long timeout;
    private final Handler<TestContext> before;
    private final Handler<TestContext> after;
    private final Handler<TestContext> beforeEach;
    private final Handler<TestContext> afterEach;
    private final TestCaseImpl[] tests;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<TestCaseReport> handler;

    TestSuiteReportImpl(String name, long timeout, Handler<TestContext> before, Handler<TestContext> after, Handler<TestContext> beforeEach, Handler<TestContext> afterEach, TestCaseImpl[] tests) {
        this.name = name;
        this.timeout = timeout;
        this.before = before;
        this.after = after;
        this.beforeEach = beforeEach;
        this.afterEach = afterEach;
        this.tests = tests;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TestSuiteReport exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public TestSuiteReport handler(Handler<TestCaseReport> handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public TestSuiteReport pause() {
        return this;
    }

    @Override
    public TestSuiteReport resume() {
        return this;
    }

    @Override
    public TestSuiteReport endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    private Task<?> buildTestCasesTasks(Map<String, Object> attributes, TestCaseImpl[] tests, int index, Task<Result> endTask) {
        if (tests.length > index) {
            TestCaseImpl test = tests[index];
            Task<?> nextTask = this.buildTestCasesTasks(attributes, tests, index + 1, endTask);
            return (v, context) -> {
                TestCaseReportImpl testReport = new TestCaseReportImpl(test.name, this.timeout, test.repeat, new HashMap<String, Object>(attributes), this.beforeEach, test.handler, this.afterEach, this.exceptionHandler);
                if (this.handler != null) {
                    this.handler.handle((Object)testReport);
                }
                Task<?> task = testReport.buildTask(nextTask);
                task.execute(null, context);
            };
        }
        if (this.after != null) {
            return new TestContextTask(new TestContextImpl(new HashMap<String, Object>(attributes), this.exceptionHandler), this.after, endTask, 0L);
        }
        return endTask;
    }

    private Task<?> buildTask() {
        Task<Result> endTask = (result, context) -> {
            if (result != null && result.failure != null && this.exceptionHandler != null) {
                this.exceptionHandler.handle((Object)result.failure);
            }
            if (this.endHandler != null) {
                this.endHandler.handle(null);
            }
        };
        if (this.before != null) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            return new TestContextTask(new TestContextImpl(attributes, this.exceptionHandler), this.before, result -> {
                if (result.failure == null) {
                    Task<?> runTask = this.buildTestCasesTasks(attributes, this.tests, 0, endTask);
                    return (result_, context) -> runTask.execute(null, context);
                }
                return endTask;
            }, 0L);
        }
        return this.buildTestCasesTasks(new HashMap<String, Object>(), this.tests, 0, endTask);
    }

    public void run(ExecutionContext context) {
        context.run(this.buildTask());
    }

    public void run(Boolean useEventLoop) {
        Context context = null;
        if (useEventLoop == null) {
            context = Vertx.currentContext();
        } else if (useEventLoop.booleanValue() && (context = Vertx.currentContext()) == null) {
            throw new IllegalStateException("No event loop, your test should either provide a Vertx instance or be executed in a Verticle");
        }
        new ExecutionContext(context).run(this.buildTask());
    }

    public void run(Vertx vertx, Boolean useEventLoop) {
        Context context = Boolean.FALSE.equals(useEventLoop) ? null : vertx.getOrCreateContext();
        Task<?> task = this.buildTask();
        new ExecutionContext(context).run(task);
    }
}

