/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.SwingUtil;
import ccl.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;

public class DateField
extends JTextField
implements CaretListener {
    private String _sTimezoneID = null;
    private int _oldDot = 0;

    private void _setInternal(boolean internal_) {
        ((DateDocument)this.getDocument())._bInternal = internal_;
    }

    protected Document createDefaultModel() {
        return new DateDocument();
    }

    public DateField(String sTimezoneID_) {
        this.setBorder(SwingUtil.createCCLBorder());
        this._sTimezoneID = sTimezoneID_;
        ((DateDocument)this.getDocument()).setTimezoneID(this._sTimezoneID);
        DateTextAction pDateTextAction = new DateTextAction(sTimezoneID_);
        Keymap kmOld = this.getKeymap();
        Keymap kmNew = JTextComponent.addKeymap(null, kmOld);
        KeyStroke ksCtrlD = KeyStroke.getKeyStroke(68, 2);
        kmNew.removeKeyStrokeBinding(ksCtrlD);
        kmNew.addActionForKeyStroke(ksCtrlD, pDateTextAction);
        KeyStroke ksT = KeyStroke.getKeyStroke('t');
        kmNew.removeKeyStrokeBinding(ksT);
        kmNew.addActionForKeyStroke(ksT, pDateTextAction);
        DeleteTextAction delete = new DeleteTextAction();
        KeyStroke ksDel = KeyStroke.getKeyStroke(127, 0);
        kmNew.removeKeyStrokeBinding(ksDel);
        kmNew.addActionForKeyStroke(ksDel, delete);
        KeyStroke ksBack = KeyStroke.getKeyStroke(8, 0);
        kmNew.removeKeyStrokeBinding(ksBack);
        kmNew.addActionForKeyStroke(ksBack, delete);
        DigitTextAction increase = new DigitTextAction(true);
        KeyStroke ksUp = KeyStroke.getKeyStroke(38, 0);
        kmNew.removeKeyStrokeBinding(ksUp);
        kmNew.addActionForKeyStroke(ksUp, increase);
        DigitTextAction decrease = new DigitTextAction(false);
        KeyStroke ksDown = KeyStroke.getKeyStroke(40, 0);
        kmNew.removeKeyStrokeBinding(ksDown);
        kmNew.addActionForKeyStroke(ksDown, decrease);
        this.setKeymap(kmNew);
        this.addCaretListener(this);
        Dimension dimSize = new Dimension(92, 24);
        this.setPreferredSize(new Dimension(dimSize));
        this.setMinimumSize(new Dimension(dimSize));
    }

    public void clear() {
        this._setInternal(true);
        this.setCaretPosition(0);
        super.setText("");
        this._setInternal(false);
    }

    public void setToday() {
        this.setText(Util.getDate(Util.getCalendar(this._sTimezoneID)));
    }

    public void setText(String sText_) {
        if (Util.isEmpty(sText_)) {
            this.clear();
            return;
        }
        super.setText(sText_);
    }

    public void caretUpdate(CaretEvent event_) {
        int dot = event_.getDot();
        Util.debug(this, "caretUpdate(..).dot:     " + dot);
        Util.debug(this, "caretUpdate(..)._oldDot: " + this._oldDot);
        if (dot == 10) {
            this._oldDot = dot;
            this.setCaretPosition(dot - 1);
        }
        if (((DateDocument)this.getDocument())._bInternal) {
            this._oldDot = dot;
            return;
        }
        if (dot == 4 || dot == 7) {
            if (this._oldDot > dot) {
                this._oldDot = dot;
                this.setCaretPosition(dot - 1);
            } else if (this.getDocument().getLength() > dot) {
                this._oldDot = dot;
                this.setCaretPosition(dot + 1);
            }
        } else {
            this._oldDot = dot;
        }
    }

    public boolean isDateValid() {
        return Util.isDateValid(this.getText());
    }

    public static void main(String[] asArg_) {
        Util.setDebug(true);
        JFrame frmMain = new JFrame("DateField Test");
        frmMain.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event_) {
                System.exit(0);
            }
        });
        DateField pDateField = new DateField("CET");
        frmMain.getContentPane().add(pDateField);
        ((Component)frmMain).setSize(200, 60);
        ((Component)frmMain).setVisible(true);
        SwingUtil.centerComponent(frmMain);
    }

    static class DigitTextAction
    extends TextAction {
        private boolean _bIncrease = true;

        public DigitTextAction(boolean bIncrease_) {
            super("DigitTextAction");
            this._bIncrease = bIncrease_;
        }

        public void actionPerformed(ActionEvent pActionEvent_) {
            DateField dateField = (DateField)this.getTextComponent(pActionEvent_);
            int caret = dateField.getCaretPosition();
            String sDate = dateField.getText();
            char digit = sDate.charAt(caret);
            if (digit == '-') {
                return;
            }
            char maxDigit = '9';
            if (caret == 5) {
                maxDigit = '1';
            }
            if (caret == 6 && sDate.charAt(5) == '1') {
                maxDigit = '2';
            }
            if (caret == 8) {
                maxDigit = '3';
            }
            if (caret == 9 && sDate.charAt(8) == '3') {
                maxDigit = '1';
            }
            if (this._bIncrease) {
                if ((digit = (char)(digit + '\u0001')) > maxDigit) {
                    digit = '0';
                    if (caret == 6 && sDate.charAt(5) == '0' || caret == 9 && sDate.charAt(caret - 1) == '0' || caret == 8 && sDate.charAt(caret + 1) == '0') {
                        digit = (char)(digit + '\u0001');
                    }
                }
                if (!Util.isDateValid(sDate = sDate.substring(0, caret) + digit + sDate.substring(caret + 1))) {
                    digit = '0';
                    sDate = sDate.substring(0, caret) + digit + sDate.substring(caret + 1);
                }
            } else {
                if ((digit = (char)(digit - '\u0001')) < '0') {
                    digit = maxDigit;
                }
                if (!Util.isDateValid(sDate = sDate.substring(0, caret) + digit + sDate.substring(caret + 1))) {
                    digit = maxDigit;
                    sDate = sDate.substring(0, caret) + digit + sDate.substring(caret + 1);
                }
            }
            if (Util.isDateValid(sDate)) {
                dateField.setText(sDate);
                dateField.setCaretPosition(caret);
            }
        }
    }

    static class DeleteTextAction
    extends TextAction {
        public DeleteTextAction() {
            super("DeleteTextAction");
        }

        public void actionPerformed(ActionEvent pActionEvent_) {
            DateField dateField = (DateField)this.getTextComponent(pActionEvent_);
            dateField.clear();
        }
    }

    static class DateTextAction
    extends TextAction {
        private String _sTimezoneID = null;

        public DateTextAction(String sTimezoneID_) {
            super("DateTextAction");
            this._sTimezoneID = sTimezoneID_;
        }

        public void actionPerformed(ActionEvent pActionEvent_) {
            JTextComponent txtTarget = this.getTextComponent(pActionEvent_);
            txtTarget.setText(Util.getDate(Util.getCalendar(this._sTimezoneID)));
        }
    }

    static class DateDocument
    extends PlainDocument {
        boolean _bInternal = false;
        private String _sTimezoneID = null;

        public void setTimezoneID(String sTimezoneID_) {
            this._sTimezoneID = sTimezoneID_;
        }

        public void remove(int offs_, int length_) throws BadLocationException {
            if (this._bInternal) {
                super.remove(offs_, length_);
            }
        }

        private void _removeChar(int position_) throws BadLocationException {
            if (position_ < this.getLength()) {
                this._bInternal = true;
                super.remove(position_, 1);
                this._bInternal = false;
            }
        }

        private void _insert(int position_, char char_) throws BadLocationException {
            this._removeChar(position_);
            super.insertString(position_, Util.cToS(char_), null);
        }

        public void insertString(int offs_, String sInsert_, AttributeSet atsUnused_) throws BadLocationException {
            Util.debug(this, "insertString(..).offs_: " + offs_);
            Util.debug(this, "insertString(..).sInsert_: " + sInsert_);
            if (Util.isEmpty(sInsert_)) {
                return;
            }
            String sOldDate = this.getText(0, this.getLength());
            String sFutureDate = sOldDate.substring(0, offs_);
            sFutureDate = sFutureDate + sInsert_;
            if (sOldDate.length() > offs_ + sInsert_.length()) {
                sFutureDate = sFutureDate + sOldDate.substring(offs_ + sInsert_.length());
            }
            if (!Util.isDateValid(sFutureDate)) {
                if (sInsert_.length() > 1 || this.getLength() == 0) {
                    String sToday = Util.getDate(Util.getCalendar(this._sTimezoneID));
                    this._bInternal = true;
                    this.remove(0, this.getLength());
                    this.insertString(0, sToday, atsUnused_);
                    this._bInternal = false;
                }
                return;
            }
            int position = offs_;
            while (position < offs_ + sInsert_.length()) {
                char cMax;
                Util.debug(this, "insertString(..).position: " + position);
                char cNext = sInsert_.charAt(position - offs_);
                Util.debug(this, "insertString(..).cNext: " + cNext);
                if (position < 4 && Util.isDigit(cNext)) {
                    this._insert(position, cNext);
                }
                if ((position == 4 || position == 7) && cNext == '-') {
                    this._insert(position, cNext);
                }
                if (position == 5) {
                    if (cNext == '0') {
                        this._insert(position, cNext);
                    }
                    if (cNext == '1') {
                        int cNextMonth = 48;
                        if (sInsert_.length() > position - offs_ + 1) {
                            cNextMonth = sInsert_.charAt(position - offs_ + 1);
                        } else if (this.getLength() > 6) {
                            cNextMonth = this.getText(6, 1).charAt(0);
                        }
                        if (cNextMonth <= 50) {
                            this._insert(position, cNext);
                        }
                    }
                }
                if (position == 6) {
                    cMax = '9';
                    boolean bOctoberOrLater = this.getText(5, 1).equals("1");
                    if (bOctoberOrLater) {
                        cMax = '2';
                    }
                    if ('0' <= cNext && cNext <= cMax) {
                        this._insert(position, cNext);
                    }
                }
                if (position == 8) {
                    if ('0' <= cNext && cNext <= '2') {
                        this._insert(position, cNext);
                    }
                    if (cNext == '3') {
                        int cNextDay = 48;
                        if (sInsert_.length() > position - offs_ + 1) {
                            cNextDay = sInsert_.charAt(position - offs_ + 1);
                        } else if (this.getLength() > 9) {
                            cNextDay = this.getText(9, 1).charAt(0);
                        }
                        if (cNextDay <= 49) {
                            this._insert(position, cNext);
                        }
                    }
                }
                if (position == 9) {
                    cMax = '9';
                    boolean b30OrGreater = this.getText(8, 1).equals("3");
                    if (b30OrGreater) {
                        cMax = '1';
                    }
                    if ('0' <= cNext && cNext <= cMax) {
                        this._insert(position, cNext);
                    }
                }
                ++position;
            }
            if (position == 4 || position == 7) {
                this._bInternal = true;
                this.insertString(position, "-", atsUnused_);
                this._bInternal = false;
            }
        }
    }
}

