/*
 * Decompiled with CFR 0.152.
 */
package lti.java.jcf;

import java.io.IOException;
import lti.java.jcf.JcfAttributeCollection;
import lti.java.jcf.JcfClassInput;
import lti.java.jcf.JcfClassOutput;
import lti.java.jcf.JcfConstantPool;
import lti.java.jcf.JcfInterfaceCollection;
import lti.java.jcf.JcfMemberCollection;
import lti.java.jcf.RuntimeConstants;

public class JcfClassFile
implements RuntimeConstants {
    public int hdrMagic;
    public short hdrMajor;
    public short hdrMinor;
    protected String fullClassName;
    protected JcfConstantPool constants;
    public short hdrAccessFlags;
    public short hdrThisClassName;
    public short hdrSuperClassName;
    protected JcfInterfaceCollection interfaces;
    protected JcfMemberCollection fields;
    protected JcfMemberCollection methods;
    protected JcfAttributeCollection attributes;

    public final String getFullName() {
        return this.fullClassName;
    }

    public final JcfConstantPool getConstantPool() {
        return this.constants;
    }

    public final JcfInterfaceCollection getInterfaces() {
        return this.interfaces;
    }

    public final JcfMemberCollection getFields() {
        return this.fields;
    }

    public final JcfMemberCollection getMethods() {
        return this.methods;
    }

    public final JcfAttributeCollection getAttributes() {
        return this.attributes;
    }

    public JcfConstantPool readConstantPool(JcfClassInput ist) throws IOException {
        return new JcfConstantPool(ist, this);
    }

    public JcfInterfaceCollection readInterfaces(JcfClassInput ist) throws IOException {
        return new JcfInterfaceCollection(ist, this.constants);
    }

    public JcfMemberCollection readMemberCollection(JcfClassInput ist) throws IOException {
        return new JcfMemberCollection(ist, this.getConstantPool());
    }

    public JcfAttributeCollection readAttributes(JcfClassInput ist) throws IOException {
        return new JcfAttributeCollection(ist, this.getConstantPool());
    }

    public JcfClassFile() {
    }

    public JcfClassFile(JcfClassInput ist) throws IOException, ClassFormatError {
        this.read(ist);
    }

    public boolean isValidMagic(int magic) {
        return magic == -889275714;
    }

    public void read(JcfClassInput ist) throws IOException, ClassFormatError {
        this.hdrMagic = ist.readIntVerbatim();
        if (!this.isValidMagic(this.hdrMagic)) {
            throw new ClassFormatError("Invalid magic signature");
        }
        this.hdrMinor = ist.readShort();
        this.hdrMajor = ist.readShort();
        this.constants = this.readConstantPool(ist);
        this.hdrAccessFlags = ist.readShortVerbatim();
        this.hdrThisClassName = ist.readCPRef();
        this.hdrSuperClassName = ist.readCPRef();
        this.fullClassName = this.constants.classNameAt(this.hdrThisClassName);
        this.interfaces = this.readInterfaces(ist);
        this.fields = this.readMemberCollection(ist);
        this.methods = this.readMemberCollection(ist);
        this.attributes = this.readAttributes(ist);
    }

    public void write(JcfClassOutput ost) throws IOException {
        ost.writeIntVerbatim(this.hdrMagic);
        ost.writeShort(this.hdrMinor);
        ost.writeShort(this.hdrMajor);
        this.getConstantPool().write(ost);
        ost.writeShortVerbatim(this.hdrAccessFlags);
        ost.writeCPRef(this.hdrThisClassName);
        ost.writeCPRef(this.hdrSuperClassName);
        this.getInterfaces().write(ost);
        this.getFields().write(ost);
        this.getMethods().write(ost);
        this.getAttributes().write(ost);
    }
}

