/*
 * Decompiled with CFR 0.152.
 */
package me.chyxion.jdbc;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.chyxion.jdbc.BasicJdbc;
import me.chyxion.jdbc.CustomResolver;
import me.chyxion.jdbc.Order;
import me.chyxion.jdbc.Ro;
import me.chyxion.jdbc.So;
import me.chyxion.jdbc.SqlAndArgs;
import me.chyxion.jdbc.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicJdbcSupport
implements BasicJdbc {
    private static final Logger log = LoggerFactory.getLogger(BasicJdbcSupport.class);
    Connection conn;
    CustomResolver customResolver;

    public BasicJdbcSupport(Connection conn, CustomResolver customResolver) {
        this.conn = conn;
        this.customResolver = customResolver;
    }

    public BasicJdbcSupport() {
    }

    @Override
    public <T> List<T> listValue(final String sql, Object ... values) {
        return this.list(new Ro<T>(){

            @Override
            public T exec(ResultSet rs) throws SQLException {
                if (rs.getMetaData().getColumnCount() > 1) {
                    throw new IllegalStateException(BasicJdbcSupport.this.fmt("List Values By SQL [{}] Expected One Column To Be Returned, But Found More Than One", new Object[]{sql}));
                }
                return BasicJdbcSupport.this.customResolver.readValue(rs, 1);
            }
        }, sql, values);
    }

    @Override
    public <T> T findValue(final String sql, Object ... values) {
        return this.findOne(new Ro<T>(){

            @Override
            public T exec(ResultSet rs) throws SQLException {
                if (rs.getMetaData().getColumnCount() > 1) {
                    throw new IllegalStateException(BasicJdbcSupport.this.fmt("Find Value By SQL [{}] Expected One Column To Be Returned, But Found More Than One", new Object[]{sql}));
                }
                return BasicJdbcSupport.this.customResolver.readValue(rs, 1);
            }
        }, sql, values);
    }

    @Override
    public <T> T query(final Ro<T> rso, final String sql, final Object ... args) {
        return this.exec(new So<T>(){

            @Override
            public Statement build() throws SQLException {
                return BasicJdbcSupport.this.prepareStatement(BasicJdbcSupport.this.conn, sql, Arrays.asList(args));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T exec(Statement statement) throws SQLException {
                ResultSet rs = null;
                try {
                    rs = BasicJdbcSupport.this.ps(statement).executeQuery();
                    Object t = rso.exec(rs);
                    return t;
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {
                            log.warn("Result Set Close Error Cause", (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    @Override
    public boolean execute(final String sql, final Object ... args) {
        return this.exec(new So<Boolean>(){

            @Override
            public Statement build() throws SQLException {
                return BasicJdbcSupport.this.prepareStatement(BasicJdbcSupport.this.conn, sql, Arrays.asList(args));
            }

            @Override
            public Boolean exec(Statement statement) throws SQLException {
                return BasicJdbcSupport.this.ps(statement).execute();
            }
        });
    }

    @Override
    public int executeBatch(final String sql, final int batchSize, final Collection<?> ... args) {
        log.info("execute batch[{}]", (Object)sql);
        return this.exec(new So<Integer>(){

            @Override
            public Statement build() throws SQLException {
                return BasicJdbcSupport.this.conn.prepareStatement(sql);
            }

            @Override
            public Integer exec(Statement statement) throws SQLException {
                int result = 0;
                int i = 0;
                int bs = batchSize > 0 ? batchSize : 16;
                for (Collection list : args) {
                    BasicJdbcSupport.this.setValues(BasicJdbcSupport.this.ps(statement), list);
                    BasicJdbcSupport.this.ps(statement).addBatch();
                    if (++i % bs != 0 || i == 0) continue;
                    result += BasicJdbcSupport.this.sum(statement.executeBatch());
                }
                return result += BasicJdbcSupport.this.sum(statement.executeBatch());
            }
        });
    }

    @Override
    public int executeBatch(String sql, int batchSize, Collection<Collection<?>> args) {
        return this.executeBatch(sql, batchSize, args.toArray(new Collection[0]));
    }

    @Override
    public int insert(String table, Collection<String> cols, Collection<Collection<?>> values, int batchSize) {
        return this.executeBatch(this.genInsertSQL(table, cols), batchSize, values.toArray(new Collection[0]));
    }

    @Override
    public int insert(String table, Map<String, ?> data) {
        Set<String> cols = data.keySet();
        LinkedList values = new LinkedList();
        for (String col : cols) {
            values.add(data.get(col));
        }
        return this.update(this.genInsertSQL(table, cols), values);
    }

    @Override
    public int update(final String sql, final Object ... values) {
        return this.exec(new So<Integer>(){

            @Override
            public Statement build() throws SQLException {
                return BasicJdbcSupport.this.prepareStatement(BasicJdbcSupport.this.conn, sql, Arrays.asList(values));
            }

            @Override
            public Integer exec(Statement statement) throws SQLException {
                return BasicJdbcSupport.this.ps(statement).executeUpdate();
            }
        });
    }

    @Override
    public List<Map<String, Object>> listMap(String sql, Object ... values) {
        return this.list(new Ro<Map<String, Object>>(){

            @Override
            public Map<String, Object> exec(ResultSet rs) throws SQLException {
                return BasicJdbcSupport.this.readMap(rs);
            }
        }, sql, values);
    }

    @Override
    public List<Map<String, Object>> listMapPage(String sql, Collection<Order> orders, int start, int limit, Object ... args) {
        SqlAndArgs sa = this.customResolver.getPaginationProcessor(this.conn).process(orders, start, limit, sql, Arrays.asList(args));
        return this.query(new Ro<List<Map<String, Object>>>(){

            @Override
            public List<Map<String, Object>> exec(ResultSet rs) throws SQLException {
                return BasicJdbcSupport.this.readMapList(rs);
            }
        }, sa.getSql(), sa.getArgs());
    }

    @Override
    public Map<String, Object> findMap(String sql, Object ... values) {
        return this.findOne(new Ro<Map<String, Object>>(){

            @Override
            public Map<String, Object> exec(ResultSet rs) throws SQLException {
                return BasicJdbcSupport.this.readMap(rs);
            }
        }, sql, values);
    }

    @Override
    public <T> T findOne(final Ro<T> ro, final String sql, Object ... values) {
        return this.query(new Ro<T>(){

            @Override
            public T exec(ResultSet rs) throws SQLException {
                Object result = null;
                if (rs.next()) {
                    result = ro.exec(rs);
                }
                if (rs.next()) {
                    throw new IllegalStateException(BasicJdbcSupport.this.fmt("Find One By SQL [{}] Expected One Result (Or NULL) To Be Returned, But Found More Than One", new Object[]{sql}));
                }
                return result;
            }
        }, sql, values);
    }

    @Override
    public <T> List<T> list(final Ro<T> ro, String sql, Object ... args) {
        return (List)this.query(new Ro<List<T>>(){

            @Override
            public List<T> exec(ResultSet rs) throws SQLException {
                LinkedList result = new LinkedList();
                while (rs.next()) {
                    result.add(ro.exec(rs));
                }
                return result;
            }
        }, sql, args);
    }

    private <T> T exec(So<T> so) {
        Statement statement = null;
        try {
            statement = so.build();
            T t = so.exec(statement);
            return t;
        }
        catch (SQLException e) {
            log.error("Execute Statement Error Caused.", (Throwable)e);
            throw new IllegalStateException(e);
        }
        finally {
            if (statement != null) {
                try {
                    log.debug("Close Statement [{}].", (Object)statement);
                    statement.close();
                }
                catch (SQLException e) {
                    log.warn("Close Statement Error Cause.", (Throwable)e);
                }
            }
        }
    }

    private PreparedStatement ps(Statement statement) {
        return (PreparedStatement)statement;
    }

    private Map<String, Object> readMap(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int numColumn = metaData.getColumnCount();
        HashMap<String, Object> mapRtn = new HashMap<String, Object>();
        for (int i = 1; i <= numColumn; ++i) {
            String colName = metaData.getColumnLabel(i);
            if ("row_number__".equalsIgnoreCase(colName)) continue;
            mapRtn.put(colName, this.customResolver.readValue(rs, i));
        }
        return mapRtn;
    }

    private List<Map<String, Object>> readMapList(ResultSet rs) {
        LinkedList<Map<String, Object>> mapList = new LinkedList<Map<String, Object>>();
        try {
            while (rs.next()) {
                mapList.add(this.readMap(rs));
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return mapList;
    }

    private PreparedStatement setValues(PreparedStatement ps, Collection<?> values) throws SQLException {
        if (values != null && !values.isEmpty()) {
            int i = 0;
            for (Object value : values) {
                this.customResolver.setParam(ps, ++i, value);
            }
        }
        return ps;
    }

    private String buildSql(String sql, Map<String, ?> mapArgs, List<Object> outArgs) {
        String rtnSQL;
        if (!mapArgs.isEmpty()) {
            StringBuffer newSql = new StringBuffer();
            Matcher matcher = Pattern.compile(":\\w+").matcher(sql);
            while (matcher.find()) {
                LinkedList<Object> args = new LinkedList<Object>();
                matcher.appendReplacement(newSql, this.genArgHolder(mapArgs.get(matcher.group().substring(1)), args));
                outArgs.addAll(args);
            }
            matcher.appendTail(newSql);
            rtnSQL = newSql.toString();
        } else {
            rtnSQL = sql;
        }
        return rtnSQL;
    }

    private String buildSql(String sql, Collection<?> args, List<Object> outArgs) {
        StringBuilder newSql = new StringBuilder();
        String[] sqlSplitted = (sql + " ").split("\\?");
        if (sqlSplitted.length == 1 && args.isEmpty()) {
            newSql.append(sql);
        } else if (sqlSplitted.length == 2 && !args.isEmpty()) {
            newSql.append(sqlSplitted[0]);
            newSql.append(this.genArgHolder(args, outArgs));
            newSql.append(sqlSplitted[1]);
        } else if (sqlSplitted.length == args.size() + 1) {
            int i = 0;
            for (Object v : args) {
                LinkedList<Object> valuesExpanded = new LinkedList<Object>();
                newSql.append(sqlSplitted[i++]);
                newSql.append(this.genArgHolder(v, valuesExpanded));
                outArgs.addAll(valuesExpanded);
            }
            newSql.append(sqlSplitted[sqlSplitted.length - 1]);
        } else {
            throw new IllegalStateException(this.fmt("SQL [{}] Does Not Match Args [{}]", sql, args));
        }
        return newSql.toString();
    }

    private PreparedStatement prepareStatement(Connection conn, String sql, Collection<?> args) throws SQLException {
        String newSql;
        LinkedList<Object> newArgs = new LinkedList<Object>();
        if (args.size() == 1) {
            Object objArgs = args.iterator().next();
            if (objArgs != null && objArgs.getClass().isArray()) {
                LinkedList<Object> vh = new LinkedList<Object>();
                for (int i = 0; i < Array.getLength(objArgs); ++i) {
                    vh.add(Array.get(objArgs, i));
                }
                newSql = this.buildSql(sql, vh, newArgs);
            } else if (objArgs instanceof Collection) {
                newSql = this.buildSql(sql, (Collection)objArgs, newArgs);
            } else if (objArgs instanceof Map) {
                newSql = this.buildSql(sql, (Map)objArgs, newArgs);
            } else {
                newSql = sql;
                newArgs.add(objArgs);
            }
        } else {
            newSql = args.size() > 1 ? this.buildSql(sql, args, newArgs) : sql;
        }
        PreparedStatement ps = conn.prepareStatement(newSql);
        if (!newArgs.isEmpty()) {
            this.setValues(ps, newArgs);
        }
        return ps;
    }

    private String genArgHolder(Object arg, List<Object> argsOut) {
        String sqlRtn = null;
        if (arg != null && arg.getClass().isArray()) {
            LinkedList<String> vh = new LinkedList<String>();
            for (int i = 0; i < Array.getLength(arg); ++i) {
                argsOut.add(Array.get(arg, i));
                vh.add("?");
            }
            sqlRtn = StringUtils.join(vh, ", ");
        } else if (arg instanceof Collection) {
            Collection listValues = (Collection)arg;
            argsOut.addAll(listValues);
            Object[] vh = new String[listValues.size()];
            Arrays.fill(vh, "?");
            sqlRtn = StringUtils.join(Arrays.asList(vh), ", ");
        } else {
            argsOut.add(arg);
            sqlRtn = "?";
        }
        return sqlRtn;
    }

    private String genInsertSQL(String table, Collection<String> cols) {
        Object[] vh = new String[cols.size()];
        Arrays.fill(vh, "?");
        return new StringBuffer("insert into ").append(table).append(" (").append(StringUtils.join(cols, ", ")).append(") values (").append(StringUtils.join(Arrays.asList(vh), ", ")).append(")").toString();
    }

    private int sum(int[] v) {
        int result = 0;
        for (int i : v) {
            result += i;
        }
        return result;
    }

    private String fmt(String msg, Object ... args) {
        return MessageFormatter.format((String)msg, (Object)args).getMessage();
    }
}

