/*
 * Decompiled with CFR 0.152.
 */
package me.chyxion.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import me.chyxion.jdbc.CustomResolver;
import me.chyxion.jdbc.pagination.MySQLCompatiblePaginationProcessor;
import me.chyxion.jdbc.pagination.OracleCompatibleProcessor;
import me.chyxion.jdbc.pagination.PaginationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultCustomResolver
implements CustomResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultCustomResolver.class);
    private PaginationProcessor mySQLCompatiblePaginationProcessor = new MySQLCompatiblePaginationProcessor();
    private PaginationProcessor oracleCompatibleProcessor = new OracleCompatibleProcessor();

    DefaultCustomResolver() {
    }

    public PaginationProcessor getPaginationProcessor(Connection conn) {
        String jdbcUrl = null;
        try {
            jdbcUrl = conn.getMetaData().getURL();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Get Connection URL Error Caused", e);
        }
        log.debug("Create Pagination Processor Of JDBC URL [{}].", (Object)jdbcUrl);
        if (jdbcUrl.startsWith("jdbc:mysql:") || jdbcUrl.startsWith("jdbc:mariadb:") || jdbcUrl.startsWith("jdbc:postgresql:") || jdbcUrl.startsWith("jdbc:sqlite:") || jdbcUrl.startsWith("jdbc:cobar:") || jdbcUrl.startsWith("jdbc:h2:") || jdbcUrl.startsWith("jdbc:hsqldb:")) {
            log.debug("Returns MySQLCompatiblePaginationProcessor.");
            return this.mySQLCompatiblePaginationProcessor;
        }
        if (jdbcUrl.startsWith("jdbc:oracle:") || jdbcUrl.startsWith("jdbc:alibaba:oracle:") || jdbcUrl.startsWith("jdbc:db2:") || jdbcUrl.startsWith("jdbc:sqlserver:")) {
            log.debug("Returns OracleCompatibleProcessor.");
            return this.oracleCompatibleProcessor;
        }
        throw new IllegalStateException("Unsupported Database [" + jdbcUrl + "] Pagination, Please Set Pagination Provider");
    }

    public void setParam(PreparedStatement ps, int index, Object param) throws SQLException {
        log.debug("Set Prepared Statement [{}] Index [{}] Param [{}].", new Object[]{ps, index, param});
        if (param == null) {
            int colType = 12;
            try {
                colType = ps.getParameterMetaData().getParameterType(index);
            }
            catch (SQLException e) {
                log.debug("Get Sql Param Type [{}] Error Caused.", (Object)index, (Object)e);
            }
            log.debug("Prepared Statement Set Index [{}] Null.", (Object)index);
            ps.setNull(index, colType);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Prepared Statement Set Value [{}]#[{}]#[{}].", new Object[]{index, param.getClass().getName(), param});
            }
            ps.setObject(index, param);
        }
    }

    public Object readValue(ResultSet rs, int index) throws SQLException {
        return rs.getObject(index);
    }
}

