/*
 * Decompiled with CFR 0.152.
 */
package me.chyxion.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import me.chyxion.jdbc.BasicJdbc;
import me.chyxion.jdbc.BasicJdbcSupport;
import me.chyxion.jdbc.Co;
import me.chyxion.jdbc.CustomResolver;
import me.chyxion.jdbc.DefaultCustomResolver;
import me.chyxion.jdbc.NewbieJdbc;
import me.chyxion.jdbc.Order;
import me.chyxion.jdbc.Ro;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewbieJdbcSupport
implements NewbieJdbc {
    private static final Logger log = LoggerFactory.getLogger(NewbieJdbcSupport.class);
    private DataSource dataSource;
    private CustomResolver customResolver;

    public NewbieJdbcSupport(DataSource dataSource) {
        this(dataSource, null);
    }

    public NewbieJdbcSupport(DataSource dataSource, CustomResolver customResolver) {
        if (dataSource == null) {
            throw new IllegalArgumentException("Data Source Could Not Be Null");
        }
        this.dataSource = dataSource;
        if (customResolver == null) {
            log.info("Custom Resolver Is Not Provided, Use Default.");
            customResolver = new DefaultCustomResolver();
        }
        this.customResolver = customResolver;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public <T> T findValue(final String sql, final Object ... values) {
        return this.execute(new Co<T>(){

            @Override
            protected T run() {
                return this.findValue(sql, values);
            }
        });
    }

    @Override
    public <T> T findValue(Connection conn, String sql, Object ... values) {
        return this.bd(conn).findValue(sql, values);
    }

    @Override
    public <T> List<T> listValue(final String sql, final Object ... values) {
        return (List)this.execute(new Co<List<T>>(){

            @Override
            protected List<T> run() {
                return this.listValue(sql, values);
            }
        });
    }

    @Override
    public <T> List<T> listValue(Connection conn, String sql, Object ... values) {
        return this.bd(conn).listValue(sql, values);
    }

    @Override
    public <T> T query(final Ro<T> rso, final String strSQL, final Object ... values) {
        return this.execute(new Co<T>(){

            @Override
            protected T run() {
                return this.query(rso, strSQL, values);
            }
        });
    }

    @Override
    public <T> T query(Connection conn, Ro<T> rso, String sql, Object ... values) {
        return this.bd(conn).query(rso, sql, values);
    }

    @Override
    public <T> T execute(Co<T> co) {
        Connection conn = null;
        try {
            co.conn = conn = this.getConnection();
            co.customResolver = this.customResolver;
            T t = co.run();
            return t;
        }
        catch (SQLException e) {
            log.error("Execute Connection Operation Error Caused.", (Throwable)e);
            throw new IllegalStateException(e);
        }
        finally {
            this.close(conn);
        }
    }

    @Override
    public boolean execute(Connection conn, String sql, Object ... args) {
        return this.bd(conn).execute(sql, args);
    }

    @Override
    public boolean execute(final String sql, final Object ... args) {
        return this.execute(new Co<Boolean>(){

            @Override
            protected Boolean run() {
                return this.execute(sql, args);
            }
        });
    }

    @Override
    public <T> T executeTransaction(Co<T> co) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            co.conn = conn;
            co.customResolver = this.customResolver;
            T t = co.run();
            conn.commit();
            T t2 = t;
            return t2;
        }
        catch (Throwable e) {
            log.error("Execute Transaction Error Caused.", e);
            try {
                log.info("Rollback Transaction.");
                conn.rollback();
            }
            catch (SQLException se) {
                log.error("Execute Transaction Rollback Error Caused.", e);
                throw new IllegalStateException(se);
            }
            throw new IllegalStateException(e);
        }
        finally {
            this.close(conn);
        }
    }

    @Override
    public int executeBatch(final String sql, final int batchSize, final Collection<?> ... args) {
        return this.executeTransaction(new Co<Integer>(){

            @Override
            protected Integer run() {
                return this.executeBatch(sql, batchSize, args);
            }
        });
    }

    @Override
    public int executeBatch(String sql, int batchSize, Collection<Collection<?>> args) {
        return this.executeBatch(sql, batchSize, args.toArray(new Collection[0]));
    }

    @Override
    public int executeBatch(Connection conn, String strSQL, int batchSize, Collection<?> ... args) {
        return this.bd(conn).executeBatch(strSQL, batchSize, args);
    }

    @Override
    public int executeBatch(Connection conn, String strSQL, int batchSize, Collection<Collection<?>> args) {
        return this.bd(conn).executeBatch(strSQL, batchSize, args);
    }

    @Override
    public int insert(Connection conn, String table, Collection<String> cols, Collection<Collection<?>> args, int batchSize) {
        return this.bd(conn).insert(table, cols, args, batchSize);
    }

    @Override
    public int insert(Connection conn, String table, Map<String, ?> data) {
        return this.bd(conn).insert(table, data);
    }

    @Override
    public int insert(final String table, final Collection<String> cols, final Collection<Collection<?>> args, final int batchSize) {
        return this.execute(new Co<Integer>(){

            @Override
            protected Integer run() {
                return this.insert(table, cols, args, batchSize);
            }
        });
    }

    @Override
    public int insert(final String table, final Map<String, ?> data) {
        return this.execute(new Co<Integer>(){

            @Override
            protected Integer run() {
                return this.insert(table, data);
            }
        });
    }

    @Override
    public int update(final String sql, final Object ... args) {
        return this.execute(new Co<Integer>(){

            @Override
            protected Integer run() {
                return this.update(sql, args);
            }
        });
    }

    @Override
    public int update(Connection conn, String sql, Object ... args) {
        return this.bd(conn).update(sql, args);
    }

    @Override
    public List<Map<String, Object>> listMapPage(Connection conn, String sql, Collection<Order> orders, int start, int limit, Object ... args) {
        return this.bd(conn).listMapPage(sql, orders, start, limit, args);
    }

    @Override
    public List<Map<String, Object>> listMapPage(final String sql, final Collection<Order> orders, final int start, final int limit, final Object ... args) {
        return this.execute(new Co<List<Map<String, Object>>>(){

            @Override
            protected List<Map<String, Object>> run() {
                return this.listMapPage(sql, orders, start, limit, args);
            }
        });
    }

    @Override
    public List<Map<String, Object>> listMap(Connection conn, String sql, Object ... args) {
        return this.bd(conn).listMap(sql, args);
    }

    @Override
    public List<Map<String, Object>> listMap(final String sql, final Object ... args) {
        return this.execute(new Co<List<Map<String, Object>>>(){

            @Override
            protected List<Map<String, Object>> run() {
                return this.listMap(sql, args);
            }
        });
    }

    @Override
    public Map<String, Object> findMap(Connection conn, String sql, Object ... args) {
        return this.bd(conn).findMap(sql, args);
    }

    @Override
    public Map<String, Object> findMap(final String sql, final Object ... args) {
        return this.execute(new Co<Map<String, Object>>(){

            @Override
            protected Map<String, Object> run() {
                return this.findMap(sql, args);
            }
        });
    }

    @Override
    public <T> T findOne(final Ro<T> ro, final String sql, final Object ... args) {
        return this.execute(new Co<T>(){

            @Override
            protected T run() {
                return this.findOne(ro, sql, args);
            }
        });
    }

    @Override
    public <T> List<T> list(final Ro<T> ro, final String sql, final Object ... args) {
        return (List)this.execute(new Co<List<T>>(){

            @Override
            protected List<T> run() {
                return this.list(ro, sql, args);
            }
        });
    }

    @Override
    public <T> T findOne(Connection conn, Ro<T> ro, String sql, Object ... args) {
        return this.bd(conn).findOne(ro, sql, args);
    }

    @Override
    public <T> List<T> list(Connection conn, Ro<T> ro, String sql, Object ... args) {
        return this.bd(conn).list(ro, sql, args);
    }

    private Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Get Database Connection Error Caused", e);
        }
    }

    private void close(Connection conn) {
        if (conn != null) {
            try {
                log.debug("Close Database Connection [{}].", (Object)conn);
                conn.close();
            }
            catch (SQLException e) {
                log.warn("Close Connection Error Caused.", (Throwable)e);
            }
        }
    }

    private BasicJdbc bd(Connection conn) {
        return new BasicJdbcSupport(conn, this.customResolver);
    }
}

