/*
 * Decompiled with CFR 0.152.
 */
package me.chyxion.jdbc.pagination;

import java.util.Collection;
import me.chyxion.jdbc.Order;
import me.chyxion.jdbc.SqlAndArgs;
import me.chyxion.jdbc.pagination.PaginationProcessor;
import me.chyxion.jdbc.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLCompatiblePaginationProcessor
implements PaginationProcessor {
    private static final Logger log = LoggerFactory.getLogger(MySQLCompatiblePaginationProcessor.class);

    @Override
    public SqlAndArgs process(Collection<Order> orders, int start, int limit, String sql, Collection<? super Object> args) {
        log.info("Process MySQL Compatible Pagination Sql [{}].", (Object)sql);
        sql = sql + " order by " + StringUtils.join(orders, ", ") + " limit ?";
        args.add((Object)start);
        if (limit > 0) {
            sql = sql + ", ?";
            args.add((Object)limit);
        }
        log.info("Process Pagination Sql Result [{}].", (Object)sql);
        return new SqlAndArgs(sql, args);
    }
}

