/*
 * Decompiled with CFR 0.152.
 */
package me.chyxion.jdbc.pagination;

import java.util.Collection;
import me.chyxion.jdbc.Order;
import me.chyxion.jdbc.SqlAndArgs;
import me.chyxion.jdbc.pagination.PaginationProcessor;
import me.chyxion.jdbc.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleCompatibleProcessor
implements PaginationProcessor {
    private static final Logger log = LoggerFactory.getLogger(OracleCompatibleProcessor.class);

    @Override
    public SqlAndArgs process(Collection<Order> orders, int start, int limit, String sql, Collection<? super Object> args) {
        log.info("Process Oracle Compatible Pagination Sql [{}].", (Object)sql);
        int indexFrom = StringUtils.indexOfIgnoreCase(sql, " from ");
        StringBuilder sbSql = new StringBuilder("select * from (").append(sql.substring(0, indexFrom)).append(", row_number() over (order by ").append(StringUtils.join(orders, ", ")).append(") ").append("row_number__").append(sql.substring(indexFrom)).append(") where ").append("row_number__").append(" >= ? ");
        args.add((Object)start);
        if (limit > 0) {
            sbSql.append("and ").append("row_number__").append(" < ?");
            args.add((Object)(start + limit));
        }
        log.info("Process Pagination Sql Result [{}].", (Object)sql);
        return new SqlAndArgs(sbSql.toString(), args);
    }
}

