package me.snowdrop.istio.api;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class AnyFluentImpl<A extends AnyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AnyFluent<A>{

    private String typeUrl;
    private String value;

    public AnyFluentImpl(){
    }
    public AnyFluentImpl(Any instance){
            this.withTypeUrl(instance.getTypeUrl()); 
            this.withValue(instance.getValue()); 
    }

    public String getTypeUrl(){
            return this.typeUrl;
    }

    public A withTypeUrl(String typeUrl){
            this.typeUrl=typeUrl; return (A) this;
    }

    public Boolean hasTypeUrl(){
            return this.typeUrl != null;
    }

    public A withNewTypeUrl(String arg1){
            return (A)withTypeUrl(new String(arg1));
    }

    public A withNewTypeUrl(StringBuilder arg1){
            return (A)withTypeUrl(new String(arg1));
    }

    public A withNewTypeUrl(StringBuffer arg1){
            return (A)withTypeUrl(new String(arg1));
    }

    public String getValue(){
            return this.value;
    }

    public A withValue(String value){
            this.value=value; return (A) this;
    }

    public Boolean hasValue(){
            return this.value != null;
    }

    public A withNewValue(String arg1){
            return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuilder arg1){
            return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuffer arg1){
            return (A)withValue(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            AnyFluentImpl that = (AnyFluentImpl) o;
            if (typeUrl != null ? !typeUrl.equals(that.typeUrl) :that.typeUrl != null) return false;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            return true;
    }




}
