package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BoolValueBuilder extends BoolValueFluentImpl<BoolValueBuilder> implements VisitableBuilder<BoolValue,BoolValueBuilder>{

    BoolValueFluent<?> fluent;
    Boolean validationEnabled;

    public BoolValueBuilder(){
            this(true);
    }
    public BoolValueBuilder(Boolean validationEnabled){
            this(new BoolValue(), validationEnabled);
    }
    public BoolValueBuilder(BoolValueFluent<?> fluent){
            this(fluent, true);
    }
    public BoolValueBuilder(BoolValueFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BoolValue(), validationEnabled);
    }
    public BoolValueBuilder(BoolValueFluent<?> fluent,BoolValue instance){
            this(fluent, instance, true);
    }
    public BoolValueBuilder(BoolValueFluent<?> fluent,BoolValue instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public BoolValueBuilder(BoolValue instance){
            this(instance,true);
    }
    public BoolValueBuilder(BoolValue instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public BoolValue build(){
            BoolValue buildable = new BoolValue(fluent.isValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BoolValueBuilder that = (BoolValueBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
