
package me.snowdrop.istio.api;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.cexl.TypedValue;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "fields"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Struct implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("fields")
    @JsonPropertyDescription("")
    private Map<String, TypedValue> fields;
    private final static long serialVersionUID = 5154215726477856780L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Struct() {
    }

    /**
     * 
     * @param fields
     */
    public Struct(Map<String, TypedValue> fields) {
        super();
        this.fields = fields;
    }

    /**
     * 
     * 
     */
    @JsonProperty("fields")
    public Map<String, TypedValue> getFields() {
        return fields;
    }

    /**
     * 
     * 
     */
    @JsonProperty("fields")
    public void setFields(Map<String, TypedValue> fields) {
        this.fields = fields;
    }

}
