package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StructBuilder extends StructFluentImpl<StructBuilder> implements VisitableBuilder<Struct,StructBuilder>{

    StructFluent<?> fluent;
    Boolean validationEnabled;

    public StructBuilder(){
            this(true);
    }
    public StructBuilder(Boolean validationEnabled){
            this(new Struct(), validationEnabled);
    }
    public StructBuilder(StructFluent<?> fluent){
            this(fluent, true);
    }
    public StructBuilder(StructFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Struct(), validationEnabled);
    }
    public StructBuilder(StructFluent<?> fluent,Struct instance){
            this(fluent, instance, true);
    }
    public StructBuilder(StructFluent<?> fluent,Struct instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFields(instance.getFields()); 
            this.validationEnabled = validationEnabled; 
    }
    public StructBuilder(Struct instance){
            this(instance,true);
    }
    public StructBuilder(Struct instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFields(instance.getFields()); 
            this.validationEnabled = validationEnabled; 
    }

    public Struct build(){
            Struct buildable = new Struct(fluent.getFields());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StructBuilder that = (StructBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
