
package me.snowdrop.istio.api.authentication.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "audiences",
    "issuer",
    "jwksUri",
    "jwtHeaders",
    "jwtParams",
    "triggerRules"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Jwt implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("audiences")
    @JsonPropertyDescription("")
    private List<String> audiences = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("issuer")
    @JsonPropertyDescription("")
    private String issuer;
    /**
     * 
     * 
     */
    @JsonProperty("jwksUri")
    @JsonPropertyDescription("")
    private String jwksUri;
    /**
     * 
     * 
     */
    @JsonProperty("jwtHeaders")
    @JsonPropertyDescription("")
    private List<String> jwtHeaders = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("jwtParams")
    @JsonPropertyDescription("")
    private List<String> jwtParams = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("triggerRules")
    @JsonPropertyDescription("")
    private List<TriggerRule> triggerRules = new ArrayList<TriggerRule>();
    private final static long serialVersionUID = -7704161306671493698L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Jwt() {
    }

    /**
     * 
     * @param triggerRules
     * @param audiences
     * @param jwksUri
     * @param jwtParams
     * @param issuer
     * @param jwtHeaders
     */
    public Jwt(List<String> audiences, String issuer, String jwksUri, List<String> jwtHeaders, List<String> jwtParams, List<TriggerRule> triggerRules) {
        super();
        this.audiences = audiences;
        this.issuer = issuer;
        this.jwksUri = jwksUri;
        this.jwtHeaders = jwtHeaders;
        this.jwtParams = jwtParams;
        this.triggerRules = triggerRules;
    }

    /**
     * 
     * 
     */
    @JsonProperty("audiences")
    public List<String> getAudiences() {
        return audiences;
    }

    /**
     * 
     * 
     */
    @JsonProperty("audiences")
    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    /**
     * 
     * 
     */
    @JsonProperty("issuer")
    public String getIssuer() {
        return issuer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("issuer")
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("jwksUri")
    public String getJwksUri() {
        return jwksUri;
    }

    /**
     * 
     * 
     */
    @JsonProperty("jwksUri")
    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    /**
     * 
     * 
     */
    @JsonProperty("jwtHeaders")
    public List<String> getJwtHeaders() {
        return jwtHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("jwtHeaders")
    public void setJwtHeaders(List<String> jwtHeaders) {
        this.jwtHeaders = jwtHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("jwtParams")
    public List<String> getJwtParams() {
        return jwtParams;
    }

    /**
     * 
     * 
     */
    @JsonProperty("jwtParams")
    public void setJwtParams(List<String> jwtParams) {
        this.jwtParams = jwtParams;
    }

    /**
     * 
     * 
     */
    @JsonProperty("triggerRules")
    public List<TriggerRule> getTriggerRules() {
        return triggerRules;
    }

    /**
     * 
     * 
     */
    @JsonProperty("triggerRules")
    public void setTriggerRules(List<TriggerRule> triggerRules) {
        this.triggerRules = triggerRules;
    }

}
