package me.snowdrop.istio.api.authentication.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface JwtFluent<A extends JwtFluent<A>> extends Fluent<A>{


    public A addToAudiences(int index,String item);
    public A setToAudiences(int index,String item);
    public A addToAudiences(String... items);
    public A addAllToAudiences(Collection<String> items);
    public A removeFromAudiences(String... items);
    public A removeAllFromAudiences(Collection<String> items);
    public List<String> getAudiences();
    public String getAudience(int index);
    public String getFirstAudience();
    public String getLastAudience();
    public String getMatchingAudience(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingAudience(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withAudiences(List<String> audiences);
    public A withAudiences(String... audiences);
    public Boolean hasAudiences();
    public A addNewAudience(String arg1);
    public A addNewAudience(StringBuilder arg1);
    public A addNewAudience(StringBuffer arg1);
    public String getIssuer();
    public A withIssuer(String issuer);
    public Boolean hasIssuer();
    public A withNewIssuer(String arg1);
    public A withNewIssuer(StringBuilder arg1);
    public A withNewIssuer(StringBuffer arg1);
    public String getJwksUri();
    public A withJwksUri(String jwksUri);
    public Boolean hasJwksUri();
    public A withNewJwksUri(String arg1);
    public A withNewJwksUri(StringBuilder arg1);
    public A withNewJwksUri(StringBuffer arg1);
    public A addToJwtHeaders(int index,String item);
    public A setToJwtHeaders(int index,String item);
    public A addToJwtHeaders(String... items);
    public A addAllToJwtHeaders(Collection<String> items);
    public A removeFromJwtHeaders(String... items);
    public A removeAllFromJwtHeaders(Collection<String> items);
    public List<String> getJwtHeaders();
    public String getJwtHeader(int index);
    public String getFirstJwtHeader();
    public String getLastJwtHeader();
    public String getMatchingJwtHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingJwtHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withJwtHeaders(List<String> jwtHeaders);
    public A withJwtHeaders(String... jwtHeaders);
    public Boolean hasJwtHeaders();
    public A addNewJwtHeader(String arg1);
    public A addNewJwtHeader(StringBuilder arg1);
    public A addNewJwtHeader(StringBuffer arg1);
    public A addToJwtParams(int index,String item);
    public A setToJwtParams(int index,String item);
    public A addToJwtParams(String... items);
    public A addAllToJwtParams(Collection<String> items);
    public A removeFromJwtParams(String... items);
    public A removeAllFromJwtParams(Collection<String> items);
    public List<String> getJwtParams();
    public String getJwtParam(int index);
    public String getFirstJwtParam();
    public String getLastJwtParam();
    public String getMatchingJwtParam(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingJwtParam(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withJwtParams(List<String> jwtParams);
    public A withJwtParams(String... jwtParams);
    public Boolean hasJwtParams();
    public A addNewJwtParam(String arg1);
    public A addNewJwtParam(StringBuilder arg1);
    public A addNewJwtParam(StringBuffer arg1);
    public A addToTriggerRules(int index,TriggerRule item);
    public A setToTriggerRules(int index,TriggerRule item);
    public A addToTriggerRules(TriggerRule... items);
    public A addAllToTriggerRules(Collection<TriggerRule> items);
    public A removeFromTriggerRules(TriggerRule... items);
    public A removeAllFromTriggerRules(Collection<TriggerRule> items);
    public A removeMatchingFromTriggerRules(io.fabric8.kubernetes.api.builder.Predicate<TriggerRuleBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTriggerRules instead.
 * @return The buildable object.
 */
@Deprecated public List<TriggerRule> getTriggerRules();
    public List<TriggerRule> buildTriggerRules();
    public TriggerRule buildTriggerRule(int index);
    public TriggerRule buildFirstTriggerRule();
    public TriggerRule buildLastTriggerRule();
    public TriggerRule buildMatchingTriggerRule(io.fabric8.kubernetes.api.builder.Predicate<TriggerRuleBuilder> predicate);
    public Boolean hasMatchingTriggerRule(io.fabric8.kubernetes.api.builder.Predicate<TriggerRuleBuilder> predicate);
    public A withTriggerRules(List<TriggerRule> triggerRules);
    public A withTriggerRules(TriggerRule... triggerRules);
    public Boolean hasTriggerRules();
    public JwtFluent.TriggerRulesNested<A> addNewTriggerRule();
    public JwtFluent.TriggerRulesNested<A> addNewTriggerRuleLike(TriggerRule item);
    public JwtFluent.TriggerRulesNested<A> setNewTriggerRuleLike(int index,TriggerRule item);
    public JwtFluent.TriggerRulesNested<A> editTriggerRule(int index);
    public JwtFluent.TriggerRulesNested<A> editFirstTriggerRule();
    public JwtFluent.TriggerRulesNested<A> editLastTriggerRule();
    public JwtFluent.TriggerRulesNested<A> editMatchingTriggerRule(io.fabric8.kubernetes.api.builder.Predicate<TriggerRuleBuilder> predicate);

    public interface TriggerRulesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TriggerRuleFluent<JwtFluent.TriggerRulesNested<N>>{

        
    public N and();    public N endTriggerRule();
}


}
