package me.snowdrop.istio.api.authentication.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class JwtFluentImpl<A extends JwtFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JwtFluent<A>{

    private List<String> audiences;
    private String issuer;
    private String jwksUri;
    private List<String> jwtHeaders;
    private List<String> jwtParams;
    private List<TriggerRuleBuilder> triggerRules;

    public JwtFluentImpl(){
    }
    public JwtFluentImpl(Jwt instance){
            this.withAudiences(instance.getAudiences()); 
            this.withIssuer(instance.getIssuer()); 
            this.withJwksUri(instance.getJwksUri()); 
            this.withJwtHeaders(instance.getJwtHeaders()); 
            this.withJwtParams(instance.getJwtParams()); 
            this.withTriggerRules(instance.getTriggerRules()); 
    }

    public A addToAudiences(int index,String item){
            if (this.audiences == null) {this.audiences = new ArrayList<String>();}
            this.audiences.add(index, item);
            return (A)this;
    }

    public A setToAudiences(int index,String item){
            if (this.audiences == null) {this.audiences = new ArrayList<String>();}
            this.audiences.set(index, item); return (A)this;
    }

    public A addToAudiences(String... items){
            if (this.audiences == null) {this.audiences = new ArrayList<String>();}
            for (String item : items) {this.audiences.add(item);} return (A)this;
    }

    public A addAllToAudiences(Collection<String> items){
            if (this.audiences == null) {this.audiences = new ArrayList<String>();}
            for (String item : items) {this.audiences.add(item);} return (A)this;
    }

    public A removeFromAudiences(String... items){
            for (String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
    }

    public A removeAllFromAudiences(Collection<String> items){
            for (String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
    }

    public List<String> getAudiences(){
            return this.audiences;
    }

    public String getAudience(int index){
            return this.audiences.get(index);
    }

    public String getFirstAudience(){
            return this.audiences.get(0);
    }

    public String getLastAudience(){
            return this.audiences.get(audiences.size() - 1);
    }

    public String getMatchingAudience(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: audiences) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAudience(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: audiences) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAudiences(List<String> audiences){
            if (this.audiences != null) { _visitables.get("audiences").removeAll(this.audiences);}
            if (audiences != null) {this.audiences = new ArrayList<String>(); for (String item : audiences){this.addToAudiences(item);}} else { this.audiences = null;} return (A) this;
    }

    public A withAudiences(String... audiences){
            if (this.audiences != null) {this.audiences.clear();}
            if (audiences != null) {for (String item :audiences){ this.addToAudiences(item);}} return (A) this;
    }

    public Boolean hasAudiences(){
            return audiences != null && !audiences.isEmpty();
    }

    public A addNewAudience(String arg1){
            return (A)addToAudiences(new String(arg1));
    }

    public A addNewAudience(StringBuilder arg1){
            return (A)addToAudiences(new String(arg1));
    }

    public A addNewAudience(StringBuffer arg1){
            return (A)addToAudiences(new String(arg1));
    }

    public String getIssuer(){
            return this.issuer;
    }

    public A withIssuer(String issuer){
            this.issuer=issuer; return (A) this;
    }

    public Boolean hasIssuer(){
            return this.issuer != null;
    }

    public A withNewIssuer(String arg1){
            return (A)withIssuer(new String(arg1));
    }

    public A withNewIssuer(StringBuilder arg1){
            return (A)withIssuer(new String(arg1));
    }

    public A withNewIssuer(StringBuffer arg1){
            return (A)withIssuer(new String(arg1));
    }

    public String getJwksUri(){
            return this.jwksUri;
    }

    public A withJwksUri(String jwksUri){
            this.jwksUri=jwksUri; return (A) this;
    }

    public Boolean hasJwksUri(){
            return this.jwksUri != null;
    }

    public A withNewJwksUri(String arg1){
            return (A)withJwksUri(new String(arg1));
    }

    public A withNewJwksUri(StringBuilder arg1){
            return (A)withJwksUri(new String(arg1));
    }

    public A withNewJwksUri(StringBuffer arg1){
            return (A)withJwksUri(new String(arg1));
    }

    public A addToJwtHeaders(int index,String item){
            if (this.jwtHeaders == null) {this.jwtHeaders = new ArrayList<String>();}
            this.jwtHeaders.add(index, item);
            return (A)this;
    }

    public A setToJwtHeaders(int index,String item){
            if (this.jwtHeaders == null) {this.jwtHeaders = new ArrayList<String>();}
            this.jwtHeaders.set(index, item); return (A)this;
    }

    public A addToJwtHeaders(String... items){
            if (this.jwtHeaders == null) {this.jwtHeaders = new ArrayList<String>();}
            for (String item : items) {this.jwtHeaders.add(item);} return (A)this;
    }

    public A addAllToJwtHeaders(Collection<String> items){
            if (this.jwtHeaders == null) {this.jwtHeaders = new ArrayList<String>();}
            for (String item : items) {this.jwtHeaders.add(item);} return (A)this;
    }

    public A removeFromJwtHeaders(String... items){
            for (String item : items) {if (this.jwtHeaders!= null){ this.jwtHeaders.remove(item);}} return (A)this;
    }

    public A removeAllFromJwtHeaders(Collection<String> items){
            for (String item : items) {if (this.jwtHeaders!= null){ this.jwtHeaders.remove(item);}} return (A)this;
    }

    public List<String> getJwtHeaders(){
            return this.jwtHeaders;
    }

    public String getJwtHeader(int index){
            return this.jwtHeaders.get(index);
    }

    public String getFirstJwtHeader(){
            return this.jwtHeaders.get(0);
    }

    public String getLastJwtHeader(){
            return this.jwtHeaders.get(jwtHeaders.size() - 1);
    }

    public String getMatchingJwtHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: jwtHeaders) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingJwtHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: jwtHeaders) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withJwtHeaders(List<String> jwtHeaders){
            if (this.jwtHeaders != null) { _visitables.get("jwtHeaders").removeAll(this.jwtHeaders);}
            if (jwtHeaders != null) {this.jwtHeaders = new ArrayList<String>(); for (String item : jwtHeaders){this.addToJwtHeaders(item);}} else { this.jwtHeaders = null;} return (A) this;
    }

    public A withJwtHeaders(String... jwtHeaders){
            if (this.jwtHeaders != null) {this.jwtHeaders.clear();}
            if (jwtHeaders != null) {for (String item :jwtHeaders){ this.addToJwtHeaders(item);}} return (A) this;
    }

    public Boolean hasJwtHeaders(){
            return jwtHeaders != null && !jwtHeaders.isEmpty();
    }

    public A addNewJwtHeader(String arg1){
            return (A)addToJwtHeaders(new String(arg1));
    }

    public A addNewJwtHeader(StringBuilder arg1){
            return (A)addToJwtHeaders(new String(arg1));
    }

    public A addNewJwtHeader(StringBuffer arg1){
            return (A)addToJwtHeaders(new String(arg1));
    }

    public A addToJwtParams(int index,String item){
            if (this.jwtParams == null) {this.jwtParams = new ArrayList<String>();}
            this.jwtParams.add(index, item);
            return (A)this;
    }

    public A setToJwtParams(int index,String item){
            if (this.jwtParams == null) {this.jwtParams = new ArrayList<String>();}
            this.jwtParams.set(index, item); return (A)this;
    }

    public A addToJwtParams(String... items){
            if (this.jwtParams == null) {this.jwtParams = new ArrayList<String>();}
            for (String item : items) {this.jwtParams.add(item);} return (A)this;
    }

    public A addAllToJwtParams(Collection<String> items){
            if (this.jwtParams == null) {this.jwtParams = new ArrayList<String>();}
            for (String item : items) {this.jwtParams.add(item);} return (A)this;
    }

    public A removeFromJwtParams(String... items){
            for (String item : items) {if (this.jwtParams!= null){ this.jwtParams.remove(item);}} return (A)this;
    }

    public A removeAllFromJwtParams(Collection<String> items){
            for (String item : items) {if (this.jwtParams!= null){ this.jwtParams.remove(item);}} return (A)this;
    }

    public List<String> getJwtParams(){
            return this.jwtParams;
    }

    public String getJwtParam(int index){
            return this.jwtParams.get(index);
    }

    public String getFirstJwtParam(){
            return this.jwtParams.get(0);
    }

    public String getLastJwtParam(){
            return this.jwtParams.get(jwtParams.size() - 1);
    }

    public String getMatchingJwtParam(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: jwtParams) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingJwtParam(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: jwtParams) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withJwtParams(List<String> jwtParams){
            if (this.jwtParams != null) { _visitables.get("jwtParams").removeAll(this.jwtParams);}
            if (jwtParams != null) {this.jwtParams = new ArrayList<String>(); for (String item : jwtParams){this.addToJwtParams(item);}} else { this.jwtParams = null;} return (A) this;
    }

    public A withJwtParams(String... jwtParams){
            if (this.jwtParams != null) {this.jwtParams.clear();}
            if (jwtParams != null) {for (String item :jwtParams){ this.addToJwtParams(item);}} return (A) this;
    }

    public Boolean hasJwtParams(){
            return jwtParams != null && !jwtParams.isEmpty();
    }

    public A addNewJwtParam(String arg1){
            return (A)addToJwtParams(new String(arg1));
    }

    public A addNewJwtParam(StringBuilder arg1){
            return (A)addToJwtParams(new String(arg1));
    }

    public A addNewJwtParam(StringBuffer arg1){
            return (A)addToJwtParams(new String(arg1));
    }

    public A addToTriggerRules(int index,TriggerRule item){
            if (this.triggerRules == null) {this.triggerRules = new ArrayList<TriggerRuleBuilder>();}
            TriggerRuleBuilder builder = new TriggerRuleBuilder(item);_visitables.get("triggerRules").add(index >= 0 ? index : _visitables.get("triggerRules").size(), builder);this.triggerRules.add(index >= 0 ? index : triggerRules.size(), builder); return (A)this;
    }

    public A setToTriggerRules(int index,TriggerRule item){
            if (this.triggerRules == null) {this.triggerRules = new ArrayList<TriggerRuleBuilder>();}
            TriggerRuleBuilder builder = new TriggerRuleBuilder(item);
            if (index < 0 || index >= _visitables.get("triggerRules").size()) { _visitables.get("triggerRules").add(builder); } else { _visitables.get("triggerRules").set(index, builder);}
            if (index < 0 || index >= triggerRules.size()) { triggerRules.add(builder); } else { triggerRules.set(index, builder);}
             return (A)this;
    }

    public A addToTriggerRules(TriggerRule... items){
            if (this.triggerRules == null) {this.triggerRules = new ArrayList<TriggerRuleBuilder>();}
            for (TriggerRule item : items) {TriggerRuleBuilder builder = new TriggerRuleBuilder(item);_visitables.get("triggerRules").add(builder);this.triggerRules.add(builder);} return (A)this;
    }

    public A addAllToTriggerRules(Collection<TriggerRule> items){
            if (this.triggerRules == null) {this.triggerRules = new ArrayList<TriggerRuleBuilder>();}
            for (TriggerRule item : items) {TriggerRuleBuilder builder = new TriggerRuleBuilder(item);_visitables.get("triggerRules").add(builder);this.triggerRules.add(builder);} return (A)this;
    }

    public A removeFromTriggerRules(TriggerRule... items){
            for (TriggerRule item : items) {TriggerRuleBuilder builder = new TriggerRuleBuilder(item);_visitables.get("triggerRules").remove(builder);if (this.triggerRules != null) {this.triggerRules.remove(builder);}} return (A)this;
    }

    public A removeAllFromTriggerRules(Collection<TriggerRule> items){
            for (TriggerRule item : items) {TriggerRuleBuilder builder = new TriggerRuleBuilder(item);_visitables.get("triggerRules").remove(builder);if (this.triggerRules != null) {this.triggerRules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTriggerRules(io.fabric8.kubernetes.api.builder.Predicate<TriggerRuleBuilder> predicate){
            if (triggerRules == null) return (A) this;
            final Iterator<TriggerRuleBuilder> each = triggerRules.iterator();
            final List visitables = _visitables.get("triggerRules");
            while (each.hasNext()) {
              TriggerRuleBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTriggerRules instead.
 * @return The buildable object.
 */
@Deprecated public List<TriggerRule> getTriggerRules(){
            return build(triggerRules);
    }

    public List<TriggerRule> buildTriggerRules(){
            return build(triggerRules);
    }

    public TriggerRule buildTriggerRule(int index){
            return this.triggerRules.get(index).build();
    }

    public TriggerRule buildFirstTriggerRule(){
            return this.triggerRules.get(0).build();
    }

    public TriggerRule buildLastTriggerRule(){
            return this.triggerRules.get(triggerRules.size() - 1).build();
    }

    public TriggerRule buildMatchingTriggerRule(io.fabric8.kubernetes.api.builder.Predicate<TriggerRuleBuilder> predicate){
            for (TriggerRuleBuilder item: triggerRules) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTriggerRule(io.fabric8.kubernetes.api.builder.Predicate<TriggerRuleBuilder> predicate){
            for (TriggerRuleBuilder item: triggerRules) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTriggerRules(List<TriggerRule> triggerRules){
            if (this.triggerRules != null) { _visitables.get("triggerRules").removeAll(this.triggerRules);}
            if (triggerRules != null) {this.triggerRules = new ArrayList<TriggerRuleBuilder>(); for (TriggerRule item : triggerRules){this.addToTriggerRules(item);}} else { this.triggerRules = null;} return (A) this;
    }

    public A withTriggerRules(TriggerRule... triggerRules){
            if (this.triggerRules != null) {this.triggerRules.clear();}
            if (triggerRules != null) {for (TriggerRule item :triggerRules){ this.addToTriggerRules(item);}} return (A) this;
    }

    public Boolean hasTriggerRules(){
            return triggerRules != null && !triggerRules.isEmpty();
    }

    public JwtFluent.TriggerRulesNested<A> addNewTriggerRule(){
            return new TriggerRulesNestedImpl();
    }

    public JwtFluent.TriggerRulesNested<A> addNewTriggerRuleLike(TriggerRule item){
            return new TriggerRulesNestedImpl(-1, item);
    }

    public JwtFluent.TriggerRulesNested<A> setNewTriggerRuleLike(int index,TriggerRule item){
            return new TriggerRulesNestedImpl(index, item);
    }

    public JwtFluent.TriggerRulesNested<A> editTriggerRule(int index){
            if (triggerRules.size() <= index) throw new RuntimeException("Can't edit triggerRules. Index exceeds size.");
            return setNewTriggerRuleLike(index, buildTriggerRule(index));
    }

    public JwtFluent.TriggerRulesNested<A> editFirstTriggerRule(){
            if (triggerRules.size() == 0) throw new RuntimeException("Can't edit first triggerRules. The list is empty.");
            return setNewTriggerRuleLike(0, buildTriggerRule(0));
    }

    public JwtFluent.TriggerRulesNested<A> editLastTriggerRule(){
            int index = triggerRules.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last triggerRules. The list is empty.");
            return setNewTriggerRuleLike(index, buildTriggerRule(index));
    }

    public JwtFluent.TriggerRulesNested<A> editMatchingTriggerRule(io.fabric8.kubernetes.api.builder.Predicate<TriggerRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<triggerRules.size();i++) { 
            if (predicate.apply(triggerRules.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching triggerRules. No match found.");
            return setNewTriggerRuleLike(index, buildTriggerRule(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            JwtFluentImpl that = (JwtFluentImpl) o;
            if (audiences != null ? !audiences.equals(that.audiences) :that.audiences != null) return false;
            if (issuer != null ? !issuer.equals(that.issuer) :that.issuer != null) return false;
            if (jwksUri != null ? !jwksUri.equals(that.jwksUri) :that.jwksUri != null) return false;
            if (jwtHeaders != null ? !jwtHeaders.equals(that.jwtHeaders) :that.jwtHeaders != null) return false;
            if (jwtParams != null ? !jwtParams.equals(that.jwtParams) :that.jwtParams != null) return false;
            if (triggerRules != null ? !triggerRules.equals(that.triggerRules) :that.triggerRules != null) return false;
            return true;
    }


    public class TriggerRulesNestedImpl<N> extends TriggerRuleFluentImpl<JwtFluent.TriggerRulesNested<N>> implements JwtFluent.TriggerRulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TriggerRuleBuilder builder;
        private final int index;
    
            TriggerRulesNestedImpl(int index,TriggerRule item){
                    this.index = index;
                    this.builder = new TriggerRuleBuilder(this, item);
            }
            TriggerRulesNestedImpl(){
                    this.index = -1;
                    this.builder = new TriggerRuleBuilder(this);
            }
    
    public N and(){
            return (N) JwtFluentImpl.this.setToTriggerRules(index, builder.build());
    }
    public N endTriggerRule(){
            return and();
    }

}


}
