package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MtlsParamsBuilder extends MtlsParamsFluentImpl<MtlsParamsBuilder> implements VisitableBuilder<MtlsParams,MtlsParamsBuilder>{

    MtlsParamsFluent<?> fluent;
    Boolean validationEnabled;

    public MtlsParamsBuilder(){
            this(true);
    }
    public MtlsParamsBuilder(Boolean validationEnabled){
            this(new MtlsParams(), validationEnabled);
    }
    public MtlsParamsBuilder(MtlsParamsFluent<?> fluent){
            this(fluent, true);
    }
    public MtlsParamsBuilder(MtlsParamsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MtlsParams(), validationEnabled);
    }
    public MtlsParamsBuilder(MtlsParamsFluent<?> fluent,MtlsParams instance){
            this(fluent, instance, true);
    }
    public MtlsParamsBuilder(MtlsParamsFluent<?> fluent,MtlsParams instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMtls(instance.getMtls()); 
            this.validationEnabled = validationEnabled; 
    }
    public MtlsParamsBuilder(MtlsParams instance){
            this(instance,true);
    }
    public MtlsParamsBuilder(MtlsParams instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMtls(instance.getMtls()); 
            this.validationEnabled = validationEnabled; 
    }

    public MtlsParams build(){
            MtlsParams buildable = new MtlsParams(fluent.getMtls());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MtlsParamsBuilder that = (MtlsParamsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
