
package me.snowdrop.istio.api.authentication.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "allowTls",
    "mode"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MutualTls implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("allowTls")
    @JsonPropertyDescription("")
    private Boolean allowTls;
    @JsonProperty("mode")
    private Mode mode;
    private final static long serialVersionUID = -3531990393316450574L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MutualTls() {
    }

    /**
     * 
     * @param mode
     * @param allowTls
     */
    public MutualTls(Boolean allowTls, Mode mode) {
        super();
        this.allowTls = allowTls;
        this.mode = mode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("allowTls")
    public Boolean getAllowTls() {
        return allowTls;
    }

    /**
     * 
     * 
     */
    @JsonProperty("allowTls")
    public void setAllowTls(Boolean allowTls) {
        this.allowTls = allowTls;
    }

    @JsonProperty("mode")
    public Mode getMode() {
        return mode;
    }

    @JsonProperty("mode")
    public void setMode(Mode mode) {
        this.mode = mode;
    }

}
