package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NumberPortBuilder extends NumberPortFluentImpl<NumberPortBuilder> implements VisitableBuilder<NumberPort,NumberPortBuilder>{

    NumberPortFluent<?> fluent;
    Boolean validationEnabled;

    public NumberPortBuilder(){
            this(true);
    }
    public NumberPortBuilder(Boolean validationEnabled){
            this(new NumberPort(), validationEnabled);
    }
    public NumberPortBuilder(NumberPortFluent<?> fluent){
            this(fluent, true);
    }
    public NumberPortBuilder(NumberPortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NumberPort(), validationEnabled);
    }
    public NumberPortBuilder(NumberPortFluent<?> fluent,NumberPort instance){
            this(fluent, instance, true);
    }
    public NumberPortBuilder(NumberPortFluent<?> fluent,NumberPort instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNumber(instance.getNumber()); 
            this.validationEnabled = validationEnabled; 
    }
    public NumberPortBuilder(NumberPort instance){
            this(instance,true);
    }
    public NumberPortBuilder(NumberPort instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNumber(instance.getNumber()); 
            this.validationEnabled = validationEnabled; 
    }

    public NumberPort build(){
            NumberPort buildable = new NumberPort(fluent.getNumber());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NumberPortBuilder that = (NumberPortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
