
package me.snowdrop.istio.api.authentication.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "jwt"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class OriginAuthenticationMethod implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("jwt")
    @JsonPropertyDescription("")
    private Jwt jwt;
    private final static long serialVersionUID = 5742893234867672774L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OriginAuthenticationMethod() {
    }

    /**
     * 
     * @param jwt
     */
    public OriginAuthenticationMethod(Jwt jwt) {
        super();
        this.jwt = jwt;
    }

    /**
     * 
     * 
     */
    @JsonProperty("jwt")
    public Jwt getJwt() {
        return jwt;
    }

    /**
     * 
     * 
     */
    @JsonProperty("jwt")
    public void setJwt(Jwt jwt) {
        this.jwt = jwt;
    }

}
