
package me.snowdrop.istio.api.authentication.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "params"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class PeerAuthenticationMethod implements Serializable
{

    @JsonProperty("params")
    @JsonUnwrapped
    private me.snowdrop.istio.api.authentication.v1alpha1.PeerAuthenticationMethod.Params params;
    private final static long serialVersionUID = 3588080292478104109L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PeerAuthenticationMethod() {
    }

    /**
     * 
     * @param params
     */
    public PeerAuthenticationMethod(me.snowdrop.istio.api.authentication.v1alpha1.PeerAuthenticationMethod.Params params) {
        super();
        this.params = params;
    }

    @JsonProperty("params")
    public me.snowdrop.istio.api.authentication.v1alpha1.PeerAuthenticationMethod.Params getParams() {
        return params;
    }

    @JsonProperty("params")
    public void setParams(me.snowdrop.istio.api.authentication.v1alpha1.PeerAuthenticationMethod.Params params) {
        this.params = params;
    }

    public interface Params extends Serializable
    {


    }

}
