package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface PolicyFluent<A extends PolicyFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public PolicyFluent.MetadataNested<A> withNewMetadata();
    public PolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PolicyFluent.MetadataNested<A> editMetadata();
    public PolicyFluent.MetadataNested<A> editOrNewMetadata();
    public PolicyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public PolicySpec getSpec();
    public PolicySpec buildSpec();
    public A withSpec(PolicySpec spec);
    public Boolean hasSpec();
    public PolicyFluent.SpecNested<A> withNewSpec();
    public PolicyFluent.SpecNested<A> withNewSpecLike(PolicySpec item);
    public PolicyFluent.SpecNested<A> editSpec();
    public PolicyFluent.SpecNested<A> editOrNewSpec();
    public PolicyFluent.SpecNested<A> editOrNewSpecLike(PolicySpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<PolicyFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,PolicySpecFluent<PolicyFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
