
package me.snowdrop.istio.api.authentication.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "originIsOptional",
    "origins",
    "peerIsOptional",
    "peers",
    "principalBinding",
    "targets"
})
@IstioKind(name = "Policy", plural = "policies")
@IstioApiVersion("authentication.istio.io/v1alpha1")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class PolicySpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("originIsOptional")
    @JsonPropertyDescription("")
    private Boolean originIsOptional;
    /**
     * 
     * 
     */
    @JsonProperty("origins")
    @JsonPropertyDescription("")
    private List<OriginAuthenticationMethod> origins = new ArrayList<OriginAuthenticationMethod>();
    /**
     * 
     * 
     */
    @JsonProperty("peerIsOptional")
    @JsonPropertyDescription("")
    private Boolean peerIsOptional;
    /**
     * 
     * 
     */
    @JsonProperty("peers")
    @JsonPropertyDescription("")
    private List<PeerAuthenticationMethod> peers = new ArrayList<PeerAuthenticationMethod>();
    @JsonProperty("principalBinding")
    private PrincipalBinding principalBinding;
    /**
     * 
     * 
     */
    @JsonProperty("targets")
    @JsonPropertyDescription("")
    private List<TargetSelector> targets = new ArrayList<TargetSelector>();
    private final static long serialVersionUID = -1210449252314435197L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PolicySpec() {
    }

    /**
     * 
     * @param peerIsOptional
     * @param peers
     * @param originIsOptional
     * @param origins
     * @param principalBinding
     * @param targets
     */
    public PolicySpec(Boolean originIsOptional, List<OriginAuthenticationMethod> origins, Boolean peerIsOptional, List<PeerAuthenticationMethod> peers, PrincipalBinding principalBinding, List<TargetSelector> targets) {
        super();
        this.originIsOptional = originIsOptional;
        this.origins = origins;
        this.peerIsOptional = peerIsOptional;
        this.peers = peers;
        this.principalBinding = principalBinding;
        this.targets = targets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("originIsOptional")
    public Boolean getOriginIsOptional() {
        return originIsOptional;
    }

    /**
     * 
     * 
     */
    @JsonProperty("originIsOptional")
    public void setOriginIsOptional(Boolean originIsOptional) {
        this.originIsOptional = originIsOptional;
    }

    /**
     * 
     * 
     */
    @JsonProperty("origins")
    public List<OriginAuthenticationMethod> getOrigins() {
        return origins;
    }

    /**
     * 
     * 
     */
    @JsonProperty("origins")
    public void setOrigins(List<OriginAuthenticationMethod> origins) {
        this.origins = origins;
    }

    /**
     * 
     * 
     */
    @JsonProperty("peerIsOptional")
    public Boolean getPeerIsOptional() {
        return peerIsOptional;
    }

    /**
     * 
     * 
     */
    @JsonProperty("peerIsOptional")
    public void setPeerIsOptional(Boolean peerIsOptional) {
        this.peerIsOptional = peerIsOptional;
    }

    /**
     * 
     * 
     */
    @JsonProperty("peers")
    public List<PeerAuthenticationMethod> getPeers() {
        return peers;
    }

    /**
     * 
     * 
     */
    @JsonProperty("peers")
    public void setPeers(List<PeerAuthenticationMethod> peers) {
        this.peers = peers;
    }

    @JsonProperty("principalBinding")
    public PrincipalBinding getPrincipalBinding() {
        return principalBinding;
    }

    @JsonProperty("principalBinding")
    public void setPrincipalBinding(PrincipalBinding principalBinding) {
        this.principalBinding = principalBinding;
    }

    /**
     * 
     * 
     */
    @JsonProperty("targets")
    public List<TargetSelector> getTargets() {
        return targets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("targets")
    public void setTargets(List<TargetSelector> targets) {
        this.targets = targets;
    }

}
