package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PolicySpecBuilder extends PolicySpecFluentImpl<PolicySpecBuilder> implements VisitableBuilder<PolicySpec,PolicySpecBuilder>{

    PolicySpecFluent<?> fluent;
    Boolean validationEnabled;

    public PolicySpecBuilder(){
            this(true);
    }
    public PolicySpecBuilder(Boolean validationEnabled){
            this(new PolicySpec(), validationEnabled);
    }
    public PolicySpecBuilder(PolicySpecFluent<?> fluent){
            this(fluent, true);
    }
    public PolicySpecBuilder(PolicySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PolicySpec(), validationEnabled);
    }
    public PolicySpecBuilder(PolicySpecFluent<?> fluent,PolicySpec instance){
            this(fluent, instance, true);
    }
    public PolicySpecBuilder(PolicySpecFluent<?> fluent,PolicySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withOriginIsOptional(instance.getOriginIsOptional()); 
            fluent.withOrigins(instance.getOrigins()); 
            fluent.withPeerIsOptional(instance.getPeerIsOptional()); 
            fluent.withPeers(instance.getPeers()); 
            fluent.withPrincipalBinding(instance.getPrincipalBinding()); 
            fluent.withTargets(instance.getTargets()); 
            this.validationEnabled = validationEnabled; 
    }
    public PolicySpecBuilder(PolicySpec instance){
            this(instance,true);
    }
    public PolicySpecBuilder(PolicySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withOriginIsOptional(instance.getOriginIsOptional()); 
            this.withOrigins(instance.getOrigins()); 
            this.withPeerIsOptional(instance.getPeerIsOptional()); 
            this.withPeers(instance.getPeers()); 
            this.withPrincipalBinding(instance.getPrincipalBinding()); 
            this.withTargets(instance.getTargets()); 
            this.validationEnabled = validationEnabled; 
    }

    public PolicySpec build(){
            PolicySpec buildable = new PolicySpec(fluent.isOriginIsOptional(),fluent.getOrigins(),fluent.isPeerIsOptional(),fluent.getPeers(),fluent.getPrincipalBinding(),fluent.getTargets());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicySpecBuilder that = (PolicySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
