package me.snowdrop.istio.api.authentication.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class PolicySpecFluentImpl<A extends PolicySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PolicySpecFluent<A>{

    private Boolean originIsOptional;
    private List<OriginAuthenticationMethodBuilder> origins;
    private Boolean peerIsOptional;
    private List<PeerAuthenticationMethodBuilder> peers;
    private PrincipalBinding principalBinding;
    private List<TargetSelectorBuilder> targets;

    public PolicySpecFluentImpl(){
    }
    public PolicySpecFluentImpl(PolicySpec instance){
            this.withOriginIsOptional(instance.getOriginIsOptional()); 
            this.withOrigins(instance.getOrigins()); 
            this.withPeerIsOptional(instance.getPeerIsOptional()); 
            this.withPeers(instance.getPeers()); 
            this.withPrincipalBinding(instance.getPrincipalBinding()); 
            this.withTargets(instance.getTargets()); 
    }

    public Boolean isOriginIsOptional(){
            return this.originIsOptional;
    }

    public A withOriginIsOptional(Boolean originIsOptional){
            this.originIsOptional=originIsOptional; return (A) this;
    }

    public Boolean hasOriginIsOptional(){
            return this.originIsOptional != null;
    }

    public A withNewOriginIsOptional(String arg1){
            return (A)withOriginIsOptional(new Boolean(arg1));
    }

    public A withNewOriginIsOptional(boolean arg1){
            return (A)withOriginIsOptional(new Boolean(arg1));
    }

    public A addToOrigins(int index,OriginAuthenticationMethod item){
            if (this.origins == null) {this.origins = new ArrayList<OriginAuthenticationMethodBuilder>();}
            OriginAuthenticationMethodBuilder builder = new OriginAuthenticationMethodBuilder(item);_visitables.get("origins").add(index >= 0 ? index : _visitables.get("origins").size(), builder);this.origins.add(index >= 0 ? index : origins.size(), builder); return (A)this;
    }

    public A setToOrigins(int index,OriginAuthenticationMethod item){
            if (this.origins == null) {this.origins = new ArrayList<OriginAuthenticationMethodBuilder>();}
            OriginAuthenticationMethodBuilder builder = new OriginAuthenticationMethodBuilder(item);
            if (index < 0 || index >= _visitables.get("origins").size()) { _visitables.get("origins").add(builder); } else { _visitables.get("origins").set(index, builder);}
            if (index < 0 || index >= origins.size()) { origins.add(builder); } else { origins.set(index, builder);}
             return (A)this;
    }

    public A addToOrigins(OriginAuthenticationMethod... items){
            if (this.origins == null) {this.origins = new ArrayList<OriginAuthenticationMethodBuilder>();}
            for (OriginAuthenticationMethod item : items) {OriginAuthenticationMethodBuilder builder = new OriginAuthenticationMethodBuilder(item);_visitables.get("origins").add(builder);this.origins.add(builder);} return (A)this;
    }

    public A addAllToOrigins(Collection<OriginAuthenticationMethod> items){
            if (this.origins == null) {this.origins = new ArrayList<OriginAuthenticationMethodBuilder>();}
            for (OriginAuthenticationMethod item : items) {OriginAuthenticationMethodBuilder builder = new OriginAuthenticationMethodBuilder(item);_visitables.get("origins").add(builder);this.origins.add(builder);} return (A)this;
    }

    public A removeFromOrigins(OriginAuthenticationMethod... items){
            for (OriginAuthenticationMethod item : items) {OriginAuthenticationMethodBuilder builder = new OriginAuthenticationMethodBuilder(item);_visitables.get("origins").remove(builder);if (this.origins != null) {this.origins.remove(builder);}} return (A)this;
    }

    public A removeAllFromOrigins(Collection<OriginAuthenticationMethod> items){
            for (OriginAuthenticationMethod item : items) {OriginAuthenticationMethodBuilder builder = new OriginAuthenticationMethodBuilder(item);_visitables.get("origins").remove(builder);if (this.origins != null) {this.origins.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOrigins(io.fabric8.kubernetes.api.builder.Predicate<OriginAuthenticationMethodBuilder> predicate){
            if (origins == null) return (A) this;
            final Iterator<OriginAuthenticationMethodBuilder> each = origins.iterator();
            final List visitables = _visitables.get("origins");
            while (each.hasNext()) {
              OriginAuthenticationMethodBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildOrigins instead.
 * @return The buildable object.
 */
@Deprecated public List<OriginAuthenticationMethod> getOrigins(){
            return build(origins);
    }

    public List<OriginAuthenticationMethod> buildOrigins(){
            return build(origins);
    }

    public OriginAuthenticationMethod buildOrigin(int index){
            return this.origins.get(index).build();
    }

    public OriginAuthenticationMethod buildFirstOrigin(){
            return this.origins.get(0).build();
    }

    public OriginAuthenticationMethod buildLastOrigin(){
            return this.origins.get(origins.size() - 1).build();
    }

    public OriginAuthenticationMethod buildMatchingOrigin(io.fabric8.kubernetes.api.builder.Predicate<OriginAuthenticationMethodBuilder> predicate){
            for (OriginAuthenticationMethodBuilder item: origins) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingOrigin(io.fabric8.kubernetes.api.builder.Predicate<OriginAuthenticationMethodBuilder> predicate){
            for (OriginAuthenticationMethodBuilder item: origins) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withOrigins(List<OriginAuthenticationMethod> origins){
            if (this.origins != null) { _visitables.get("origins").removeAll(this.origins);}
            if (origins != null) {this.origins = new ArrayList<OriginAuthenticationMethodBuilder>(); for (OriginAuthenticationMethod item : origins){this.addToOrigins(item);}} else { this.origins = null;} return (A) this;
    }

    public A withOrigins(OriginAuthenticationMethod... origins){
            if (this.origins != null) {this.origins.clear();}
            if (origins != null) {for (OriginAuthenticationMethod item :origins){ this.addToOrigins(item);}} return (A) this;
    }

    public Boolean hasOrigins(){
            return origins != null && !origins.isEmpty();
    }

    public PolicySpecFluent.OriginsNested<A> addNewOrigin(){
            return new OriginsNestedImpl();
    }

    public PolicySpecFluent.OriginsNested<A> addNewOriginLike(OriginAuthenticationMethod item){
            return new OriginsNestedImpl(-1, item);
    }

    public PolicySpecFluent.OriginsNested<A> setNewOriginLike(int index,OriginAuthenticationMethod item){
            return new OriginsNestedImpl(index, item);
    }

    public PolicySpecFluent.OriginsNested<A> editOrigin(int index){
            if (origins.size() <= index) throw new RuntimeException("Can't edit origins. Index exceeds size.");
            return setNewOriginLike(index, buildOrigin(index));
    }

    public PolicySpecFluent.OriginsNested<A> editFirstOrigin(){
            if (origins.size() == 0) throw new RuntimeException("Can't edit first origins. The list is empty.");
            return setNewOriginLike(0, buildOrigin(0));
    }

    public PolicySpecFluent.OriginsNested<A> editLastOrigin(){
            int index = origins.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last origins. The list is empty.");
            return setNewOriginLike(index, buildOrigin(index));
    }

    public PolicySpecFluent.OriginsNested<A> editMatchingOrigin(io.fabric8.kubernetes.api.builder.Predicate<OriginAuthenticationMethodBuilder> predicate){
            int index = -1;
            for (int i=0;i<origins.size();i++) { 
            if (predicate.apply(origins.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching origins. No match found.");
            return setNewOriginLike(index, buildOrigin(index));
    }

    public Boolean isPeerIsOptional(){
            return this.peerIsOptional;
    }

    public A withPeerIsOptional(Boolean peerIsOptional){
            this.peerIsOptional=peerIsOptional; return (A) this;
    }

    public Boolean hasPeerIsOptional(){
            return this.peerIsOptional != null;
    }

    public A withNewPeerIsOptional(String arg1){
            return (A)withPeerIsOptional(new Boolean(arg1));
    }

    public A withNewPeerIsOptional(boolean arg1){
            return (A)withPeerIsOptional(new Boolean(arg1));
    }

    public A addToPeers(int index,PeerAuthenticationMethod item){
            if (this.peers == null) {this.peers = new ArrayList<PeerAuthenticationMethodBuilder>();}
            PeerAuthenticationMethodBuilder builder = new PeerAuthenticationMethodBuilder(item);_visitables.get("peers").add(index >= 0 ? index : _visitables.get("peers").size(), builder);this.peers.add(index >= 0 ? index : peers.size(), builder); return (A)this;
    }

    public A setToPeers(int index,PeerAuthenticationMethod item){
            if (this.peers == null) {this.peers = new ArrayList<PeerAuthenticationMethodBuilder>();}
            PeerAuthenticationMethodBuilder builder = new PeerAuthenticationMethodBuilder(item);
            if (index < 0 || index >= _visitables.get("peers").size()) { _visitables.get("peers").add(builder); } else { _visitables.get("peers").set(index, builder);}
            if (index < 0 || index >= peers.size()) { peers.add(builder); } else { peers.set(index, builder);}
             return (A)this;
    }

    public A addToPeers(PeerAuthenticationMethod... items){
            if (this.peers == null) {this.peers = new ArrayList<PeerAuthenticationMethodBuilder>();}
            for (PeerAuthenticationMethod item : items) {PeerAuthenticationMethodBuilder builder = new PeerAuthenticationMethodBuilder(item);_visitables.get("peers").add(builder);this.peers.add(builder);} return (A)this;
    }

    public A addAllToPeers(Collection<PeerAuthenticationMethod> items){
            if (this.peers == null) {this.peers = new ArrayList<PeerAuthenticationMethodBuilder>();}
            for (PeerAuthenticationMethod item : items) {PeerAuthenticationMethodBuilder builder = new PeerAuthenticationMethodBuilder(item);_visitables.get("peers").add(builder);this.peers.add(builder);} return (A)this;
    }

    public A removeFromPeers(PeerAuthenticationMethod... items){
            for (PeerAuthenticationMethod item : items) {PeerAuthenticationMethodBuilder builder = new PeerAuthenticationMethodBuilder(item);_visitables.get("peers").remove(builder);if (this.peers != null) {this.peers.remove(builder);}} return (A)this;
    }

    public A removeAllFromPeers(Collection<PeerAuthenticationMethod> items){
            for (PeerAuthenticationMethod item : items) {PeerAuthenticationMethodBuilder builder = new PeerAuthenticationMethodBuilder(item);_visitables.get("peers").remove(builder);if (this.peers != null) {this.peers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPeers(io.fabric8.kubernetes.api.builder.Predicate<PeerAuthenticationMethodBuilder> predicate){
            if (peers == null) return (A) this;
            final Iterator<PeerAuthenticationMethodBuilder> each = peers.iterator();
            final List visitables = _visitables.get("peers");
            while (each.hasNext()) {
              PeerAuthenticationMethodBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPeers instead.
 * @return The buildable object.
 */
@Deprecated public List<PeerAuthenticationMethod> getPeers(){
            return build(peers);
    }

    public List<PeerAuthenticationMethod> buildPeers(){
            return build(peers);
    }

    public PeerAuthenticationMethod buildPeer(int index){
            return this.peers.get(index).build();
    }

    public PeerAuthenticationMethod buildFirstPeer(){
            return this.peers.get(0).build();
    }

    public PeerAuthenticationMethod buildLastPeer(){
            return this.peers.get(peers.size() - 1).build();
    }

    public PeerAuthenticationMethod buildMatchingPeer(io.fabric8.kubernetes.api.builder.Predicate<PeerAuthenticationMethodBuilder> predicate){
            for (PeerAuthenticationMethodBuilder item: peers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPeer(io.fabric8.kubernetes.api.builder.Predicate<PeerAuthenticationMethodBuilder> predicate){
            for (PeerAuthenticationMethodBuilder item: peers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPeers(List<PeerAuthenticationMethod> peers){
            if (this.peers != null) { _visitables.get("peers").removeAll(this.peers);}
            if (peers != null) {this.peers = new ArrayList<PeerAuthenticationMethodBuilder>(); for (PeerAuthenticationMethod item : peers){this.addToPeers(item);}} else { this.peers = null;} return (A) this;
    }

    public A withPeers(PeerAuthenticationMethod... peers){
            if (this.peers != null) {this.peers.clear();}
            if (peers != null) {for (PeerAuthenticationMethod item :peers){ this.addToPeers(item);}} return (A) this;
    }

    public Boolean hasPeers(){
            return peers != null && !peers.isEmpty();
    }

    public PolicySpecFluent.PeersNested<A> addNewPeer(){
            return new PeersNestedImpl();
    }

    public PolicySpecFluent.PeersNested<A> addNewPeerLike(PeerAuthenticationMethod item){
            return new PeersNestedImpl(-1, item);
    }

    public PolicySpecFluent.PeersNested<A> setNewPeerLike(int index,PeerAuthenticationMethod item){
            return new PeersNestedImpl(index, item);
    }

    public PolicySpecFluent.PeersNested<A> editPeer(int index){
            if (peers.size() <= index) throw new RuntimeException("Can't edit peers. Index exceeds size.");
            return setNewPeerLike(index, buildPeer(index));
    }

    public PolicySpecFluent.PeersNested<A> editFirstPeer(){
            if (peers.size() == 0) throw new RuntimeException("Can't edit first peers. The list is empty.");
            return setNewPeerLike(0, buildPeer(0));
    }

    public PolicySpecFluent.PeersNested<A> editLastPeer(){
            int index = peers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last peers. The list is empty.");
            return setNewPeerLike(index, buildPeer(index));
    }

    public PolicySpecFluent.PeersNested<A> editMatchingPeer(io.fabric8.kubernetes.api.builder.Predicate<PeerAuthenticationMethodBuilder> predicate){
            int index = -1;
            for (int i=0;i<peers.size();i++) { 
            if (predicate.apply(peers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching peers. No match found.");
            return setNewPeerLike(index, buildPeer(index));
    }

    public PrincipalBinding getPrincipalBinding(){
            return this.principalBinding;
    }

    public A withPrincipalBinding(PrincipalBinding principalBinding){
            this.principalBinding=principalBinding; return (A) this;
    }

    public Boolean hasPrincipalBinding(){
            return this.principalBinding != null;
    }

    public A addToTargets(int index,TargetSelector item){
            if (this.targets == null) {this.targets = new ArrayList<TargetSelectorBuilder>();}
            TargetSelectorBuilder builder = new TargetSelectorBuilder(item);_visitables.get("targets").add(index >= 0 ? index : _visitables.get("targets").size(), builder);this.targets.add(index >= 0 ? index : targets.size(), builder); return (A)this;
    }

    public A setToTargets(int index,TargetSelector item){
            if (this.targets == null) {this.targets = new ArrayList<TargetSelectorBuilder>();}
            TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
            if (index < 0 || index >= _visitables.get("targets").size()) { _visitables.get("targets").add(builder); } else { _visitables.get("targets").set(index, builder);}
            if (index < 0 || index >= targets.size()) { targets.add(builder); } else { targets.set(index, builder);}
             return (A)this;
    }

    public A addToTargets(TargetSelector... items){
            if (this.targets == null) {this.targets = new ArrayList<TargetSelectorBuilder>();}
            for (TargetSelector item : items) {TargetSelectorBuilder builder = new TargetSelectorBuilder(item);_visitables.get("targets").add(builder);this.targets.add(builder);} return (A)this;
    }

    public A addAllToTargets(Collection<TargetSelector> items){
            if (this.targets == null) {this.targets = new ArrayList<TargetSelectorBuilder>();}
            for (TargetSelector item : items) {TargetSelectorBuilder builder = new TargetSelectorBuilder(item);_visitables.get("targets").add(builder);this.targets.add(builder);} return (A)this;
    }

    public A removeFromTargets(TargetSelector... items){
            for (TargetSelector item : items) {TargetSelectorBuilder builder = new TargetSelectorBuilder(item);_visitables.get("targets").remove(builder);if (this.targets != null) {this.targets.remove(builder);}} return (A)this;
    }

    public A removeAllFromTargets(Collection<TargetSelector> items){
            for (TargetSelector item : items) {TargetSelectorBuilder builder = new TargetSelectorBuilder(item);_visitables.get("targets").remove(builder);if (this.targets != null) {this.targets.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTargets(io.fabric8.kubernetes.api.builder.Predicate<TargetSelectorBuilder> predicate){
            if (targets == null) return (A) this;
            final Iterator<TargetSelectorBuilder> each = targets.iterator();
            final List visitables = _visitables.get("targets");
            while (each.hasNext()) {
              TargetSelectorBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTargets instead.
 * @return The buildable object.
 */
@Deprecated public List<TargetSelector> getTargets(){
            return build(targets);
    }

    public List<TargetSelector> buildTargets(){
            return build(targets);
    }

    public TargetSelector buildTarget(int index){
            return this.targets.get(index).build();
    }

    public TargetSelector buildFirstTarget(){
            return this.targets.get(0).build();
    }

    public TargetSelector buildLastTarget(){
            return this.targets.get(targets.size() - 1).build();
    }

    public TargetSelector buildMatchingTarget(io.fabric8.kubernetes.api.builder.Predicate<TargetSelectorBuilder> predicate){
            for (TargetSelectorBuilder item: targets) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTarget(io.fabric8.kubernetes.api.builder.Predicate<TargetSelectorBuilder> predicate){
            for (TargetSelectorBuilder item: targets) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTargets(List<TargetSelector> targets){
            if (this.targets != null) { _visitables.get("targets").removeAll(this.targets);}
            if (targets != null) {this.targets = new ArrayList<TargetSelectorBuilder>(); for (TargetSelector item : targets){this.addToTargets(item);}} else { this.targets = null;} return (A) this;
    }

    public A withTargets(TargetSelector... targets){
            if (this.targets != null) {this.targets.clear();}
            if (targets != null) {for (TargetSelector item :targets){ this.addToTargets(item);}} return (A) this;
    }

    public Boolean hasTargets(){
            return targets != null && !targets.isEmpty();
    }

    public PolicySpecFluent.TargetsNested<A> addNewTarget(){
            return new TargetsNestedImpl();
    }

    public PolicySpecFluent.TargetsNested<A> addNewTargetLike(TargetSelector item){
            return new TargetsNestedImpl(-1, item);
    }

    public PolicySpecFluent.TargetsNested<A> setNewTargetLike(int index,TargetSelector item){
            return new TargetsNestedImpl(index, item);
    }

    public PolicySpecFluent.TargetsNested<A> editTarget(int index){
            if (targets.size() <= index) throw new RuntimeException("Can't edit targets. Index exceeds size.");
            return setNewTargetLike(index, buildTarget(index));
    }

    public PolicySpecFluent.TargetsNested<A> editFirstTarget(){
            if (targets.size() == 0) throw new RuntimeException("Can't edit first targets. The list is empty.");
            return setNewTargetLike(0, buildTarget(0));
    }

    public PolicySpecFluent.TargetsNested<A> editLastTarget(){
            int index = targets.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last targets. The list is empty.");
            return setNewTargetLike(index, buildTarget(index));
    }

    public PolicySpecFluent.TargetsNested<A> editMatchingTarget(io.fabric8.kubernetes.api.builder.Predicate<TargetSelectorBuilder> predicate){
            int index = -1;
            for (int i=0;i<targets.size();i++) { 
            if (predicate.apply(targets.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching targets. No match found.");
            return setNewTargetLike(index, buildTarget(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PolicySpecFluentImpl that = (PolicySpecFluentImpl) o;
            if (originIsOptional != null ? !originIsOptional.equals(that.originIsOptional) :that.originIsOptional != null) return false;
            if (origins != null ? !origins.equals(that.origins) :that.origins != null) return false;
            if (peerIsOptional != null ? !peerIsOptional.equals(that.peerIsOptional) :that.peerIsOptional != null) return false;
            if (peers != null ? !peers.equals(that.peers) :that.peers != null) return false;
            if (principalBinding != null ? !principalBinding.equals(that.principalBinding) :that.principalBinding != null) return false;
            if (targets != null ? !targets.equals(that.targets) :that.targets != null) return false;
            return true;
    }


    public class OriginsNestedImpl<N> extends OriginAuthenticationMethodFluentImpl<PolicySpecFluent.OriginsNested<N>> implements PolicySpecFluent.OriginsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OriginAuthenticationMethodBuilder builder;
        private final int index;
    
            OriginsNestedImpl(int index,OriginAuthenticationMethod item){
                    this.index = index;
                    this.builder = new OriginAuthenticationMethodBuilder(this, item);
            }
            OriginsNestedImpl(){
                    this.index = -1;
                    this.builder = new OriginAuthenticationMethodBuilder(this);
            }
    
    public N and(){
            return (N) PolicySpecFluentImpl.this.setToOrigins(index, builder.build());
    }
    public N endOrigin(){
            return and();
    }

}
    public class PeersNestedImpl<N> extends PeerAuthenticationMethodFluentImpl<PolicySpecFluent.PeersNested<N>> implements PolicySpecFluent.PeersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PeerAuthenticationMethodBuilder builder;
        private final int index;
    
            PeersNestedImpl(int index,PeerAuthenticationMethod item){
                    this.index = index;
                    this.builder = new PeerAuthenticationMethodBuilder(this, item);
            }
            PeersNestedImpl(){
                    this.index = -1;
                    this.builder = new PeerAuthenticationMethodBuilder(this);
            }
    
    public N and(){
            return (N) PolicySpecFluentImpl.this.setToPeers(index, builder.build());
    }
    public N endPeer(){
            return and();
    }

}
    public class TargetsNestedImpl<N> extends TargetSelectorFluentImpl<PolicySpecFluent.TargetsNested<N>> implements PolicySpecFluent.TargetsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TargetSelectorBuilder builder;
        private final int index;
    
            TargetsNestedImpl(int index,TargetSelector item){
                    this.index = index;
                    this.builder = new TargetSelectorBuilder(this, item);
            }
            TargetsNestedImpl(){
                    this.index = -1;
                    this.builder = new TargetSelectorBuilder(this);
            }
    
    public N and(){
            return (N) PolicySpecFluentImpl.this.setToTargets(index, builder.build());
    }
    public N endTarget(){
            return and();
    }

}


}
