package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.Boolean;

public class PortSelectorFluentImpl<A extends PortSelectorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PortSelectorFluent<A>{

    private VisitableBuilder<? extends PortSelector.Port,?> port;

    public PortSelectorFluentImpl(){
    }
    public PortSelectorFluentImpl(PortSelector instance){
            this.withPort(instance.getPort()); 
    }

    
/**
 * This method has been deprecated, please use method buildPort instead.
 * @return The buildable object.
 */
@Deprecated public PortSelector.Port getPort(){
            return this.port!=null?this.port.build():null;
    }

    public PortSelector.Port buildPort(){
            return this.port!=null?this.port.build():null;
    }

    public A withPort(PortSelector.Port port){
            if (port instanceof NamePort){ this.port= new NamePortBuilder((NamePort)port); _visitables.get("port").add(this.port);}
            if (port instanceof NumberPort){ this.port= new NumberPortBuilder((NumberPort)port); _visitables.get("port").add(this.port);}
            return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A withNamePort(NamePort namePort){
            _visitables.get("port").remove(this.port);
            if (namePort!=null){ this.port= new NamePortBuilder(namePort); _visitables.get("port").add(this.port);} return (A) this;
    }

    public PortSelectorFluent.NamePortNested<A> withNewNamePort(){
            return new NamePortNestedImpl();
    }

    public PortSelectorFluent.NamePortNested<A> withNewNamePortLike(NamePort item){
            return new NamePortNestedImpl(item);
    }

    public A withNewNamePort(String name){
            return (A)withNamePort(new NamePort(name));
    }

    public A withNumberPort(NumberPort numberPort){
            _visitables.get("port").remove(this.port);
            if (numberPort!=null){ this.port= new NumberPortBuilder(numberPort); _visitables.get("port").add(this.port);} return (A) this;
    }

    public PortSelectorFluent.NumberPortNested<A> withNewNumberPort(){
            return new NumberPortNestedImpl();
    }

    public PortSelectorFluent.NumberPortNested<A> withNewNumberPortLike(NumberPort item){
            return new NumberPortNestedImpl(item);
    }

    public A withNewNumberPort(Integer number){
            return (A)withNumberPort(new NumberPort(number));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PortSelectorFluentImpl that = (PortSelectorFluentImpl) o;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            return true;
    }


    public class NamePortNestedImpl<N> extends NamePortFluentImpl<PortSelectorFluent.NamePortNested<N>> implements PortSelectorFluent.NamePortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NamePortBuilder builder;
    
            NamePortNestedImpl(NamePort item){
                    this.builder = new NamePortBuilder(this, item);
            }
            NamePortNestedImpl(){
                    this.builder = new NamePortBuilder(this);
            }
    
    public N and(){
            return (N) PortSelectorFluentImpl.this.withNamePort(builder.build());
    }
    public N endNamePort(){
            return and();
    }

}
    public class NumberPortNestedImpl<N> extends NumberPortFluentImpl<PortSelectorFluent.NumberPortNested<N>> implements PortSelectorFluent.NumberPortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NumberPortBuilder builder;
    
            NumberPortNestedImpl(NumberPort item){
                    this.builder = new NumberPortBuilder(this, item);
            }
            NumberPortNestedImpl(){
                    this.builder = new NumberPortBuilder(this);
            }
    
    public N and(){
            return (N) PortSelectorFluentImpl.this.withNumberPort(builder.build());
    }
    public N endNumberPort(){
            return and();
    }

}


}
