
package me.snowdrop.istio.api.authentication.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "labels",
    "name",
    "ports"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TargetSelector implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("labels")
    @JsonPropertyDescription("")
    private Map<String, String> labels;
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    /**
     * 
     * 
     */
    @JsonProperty("ports")
    @JsonPropertyDescription("")
    private List<PortSelector> ports = new ArrayList<PortSelector>();
    private final static long serialVersionUID = 6777707335309600906L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TargetSelector() {
    }

    /**
     * 
     * @param name
     * @param ports
     * @param labels
     */
    public TargetSelector(Map<String, String> labels, java.lang.String name, List<PortSelector> ports) {
        super();
        this.labels = labels;
        this.name = name;
        this.ports = ports;
    }

    /**
     * 
     * 
     */
    @JsonProperty("labels")
    public Map<String, String> getLabels() {
        return labels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("labels")
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ports")
    public List<PortSelector> getPorts() {
        return ports;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ports")
    public void setPorts(List<PortSelector> ports) {
        this.ports = ports;
    }

}
