package me.snowdrop.istio.api.authentication.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface TargetSelectorFluent<A extends TargetSelectorFluent<A>> extends Fluent<A>{


    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public A addToPorts(int index,PortSelector item);
    public A setToPorts(int index,PortSelector item);
    public A addToPorts(PortSelector... items);
    public A addAllToPorts(Collection<PortSelector> items);
    public A removeFromPorts(PortSelector... items);
    public A removeAllFromPorts(Collection<PortSelector> items);
    public A removeMatchingFromPorts(io.fabric8.kubernetes.api.builder.Predicate<PortSelectorBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<PortSelector> getPorts();
    public List<PortSelector> buildPorts();
    public PortSelector buildPort(int index);
    public PortSelector buildFirstPort();
    public PortSelector buildLastPort();
    public PortSelector buildMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortSelectorBuilder> predicate);
    public Boolean hasMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortSelectorBuilder> predicate);
    public A withPorts(List<PortSelector> ports);
    public A withPorts(PortSelector... ports);
    public Boolean hasPorts();
    public TargetSelectorFluent.PortsNested<A> addNewPort();
    public TargetSelectorFluent.PortsNested<A> addNewPortLike(PortSelector item);
    public TargetSelectorFluent.PortsNested<A> setNewPortLike(int index,PortSelector item);
    public TargetSelectorFluent.PortsNested<A> editPort(int index);
    public TargetSelectorFluent.PortsNested<A> editFirstPort();
    public TargetSelectorFluent.PortsNested<A> editLastPort();
    public TargetSelectorFluent.PortsNested<A> editMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortSelectorBuilder> predicate);

    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PortSelectorFluent<TargetSelectorFluent.PortsNested<N>>{

        
    public N and();    public N endPort();
}


}
