
package me.snowdrop.istio.api.authentication.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "excludedPaths",
    "includedPaths"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TriggerRule implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("excludedPaths")
    @JsonPropertyDescription("")
    private List<StringMatch> excludedPaths = new ArrayList<StringMatch>();
    /**
     * 
     * 
     */
    @JsonProperty("includedPaths")
    @JsonPropertyDescription("")
    private List<StringMatch> includedPaths = new ArrayList<StringMatch>();
    private final static long serialVersionUID = 3237463056762246834L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TriggerRule() {
    }

    /**
     * 
     * @param includedPaths
     * @param excludedPaths
     */
    public TriggerRule(List<StringMatch> excludedPaths, List<StringMatch> includedPaths) {
        super();
        this.excludedPaths = excludedPaths;
        this.includedPaths = includedPaths;
    }

    /**
     * 
     * 
     */
    @JsonProperty("excludedPaths")
    public List<StringMatch> getExcludedPaths() {
        return excludedPaths;
    }

    /**
     * 
     * 
     */
    @JsonProperty("excludedPaths")
    public void setExcludedPaths(List<StringMatch> excludedPaths) {
        this.excludedPaths = excludedPaths;
    }

    /**
     * 
     * 
     */
    @JsonProperty("includedPaths")
    public List<StringMatch> getIncludedPaths() {
        return includedPaths;
    }

    /**
     * 
     * 
     */
    @JsonProperty("includedPaths")
    public void setIncludedPaths(List<StringMatch> includedPaths) {
        this.includedPaths = includedPaths;
    }

}
