package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerRuleBuilder extends TriggerRuleFluentImpl<TriggerRuleBuilder> implements VisitableBuilder<TriggerRule,TriggerRuleBuilder>{

    TriggerRuleFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerRuleBuilder(){
            this(true);
    }
    public TriggerRuleBuilder(Boolean validationEnabled){
            this(new TriggerRule(), validationEnabled);
    }
    public TriggerRuleBuilder(TriggerRuleFluent<?> fluent){
            this(fluent, true);
    }
    public TriggerRuleBuilder(TriggerRuleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TriggerRule(), validationEnabled);
    }
    public TriggerRuleBuilder(TriggerRuleFluent<?> fluent,TriggerRule instance){
            this(fluent, instance, true);
    }
    public TriggerRuleBuilder(TriggerRuleFluent<?> fluent,TriggerRule instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withExcludedPaths(instance.getExcludedPaths()); 
            fluent.withIncludedPaths(instance.getIncludedPaths()); 
            this.validationEnabled = validationEnabled; 
    }
    public TriggerRuleBuilder(TriggerRule instance){
            this(instance,true);
    }
    public TriggerRuleBuilder(TriggerRule instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withExcludedPaths(instance.getExcludedPaths()); 
            this.withIncludedPaths(instance.getIncludedPaths()); 
            this.validationEnabled = validationEnabled; 
    }

    public TriggerRule build(){
            TriggerRule buildable = new TriggerRule(fluent.getExcludedPaths(),fluent.getIncludedPaths());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TriggerRuleBuilder that = (TriggerRuleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
