package me.snowdrop.istio.api.authentication.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class TriggerRuleFluentImpl<A extends TriggerRuleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TriggerRuleFluent<A>{

    private List<StringMatchBuilder> excludedPaths;
    private List<StringMatchBuilder> includedPaths;

    public TriggerRuleFluentImpl(){
    }
    public TriggerRuleFluentImpl(TriggerRule instance){
            this.withExcludedPaths(instance.getExcludedPaths()); 
            this.withIncludedPaths(instance.getIncludedPaths()); 
    }

    public A addToExcludedPaths(int index,StringMatch item){
            if (this.excludedPaths == null) {this.excludedPaths = new ArrayList<StringMatchBuilder>();}
            StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("excludedPaths").add(index >= 0 ? index : _visitables.get("excludedPaths").size(), builder);this.excludedPaths.add(index >= 0 ? index : excludedPaths.size(), builder); return (A)this;
    }

    public A setToExcludedPaths(int index,StringMatch item){
            if (this.excludedPaths == null) {this.excludedPaths = new ArrayList<StringMatchBuilder>();}
            StringMatchBuilder builder = new StringMatchBuilder(item);
            if (index < 0 || index >= _visitables.get("excludedPaths").size()) { _visitables.get("excludedPaths").add(builder); } else { _visitables.get("excludedPaths").set(index, builder);}
            if (index < 0 || index >= excludedPaths.size()) { excludedPaths.add(builder); } else { excludedPaths.set(index, builder);}
             return (A)this;
    }

    public A addToExcludedPaths(StringMatch... items){
            if (this.excludedPaths == null) {this.excludedPaths = new ArrayList<StringMatchBuilder>();}
            for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("excludedPaths").add(builder);this.excludedPaths.add(builder);} return (A)this;
    }

    public A addAllToExcludedPaths(Collection<StringMatch> items){
            if (this.excludedPaths == null) {this.excludedPaths = new ArrayList<StringMatchBuilder>();}
            for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("excludedPaths").add(builder);this.excludedPaths.add(builder);} return (A)this;
    }

    public A removeFromExcludedPaths(StringMatch... items){
            for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("excludedPaths").remove(builder);if (this.excludedPaths != null) {this.excludedPaths.remove(builder);}} return (A)this;
    }

    public A removeAllFromExcludedPaths(Collection<StringMatch> items){
            for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("excludedPaths").remove(builder);if (this.excludedPaths != null) {this.excludedPaths.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromExcludedPaths(io.fabric8.kubernetes.api.builder.Predicate<StringMatchBuilder> predicate){
            if (excludedPaths == null) return (A) this;
            final Iterator<StringMatchBuilder> each = excludedPaths.iterator();
            final List visitables = _visitables.get("excludedPaths");
            while (each.hasNext()) {
              StringMatchBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildExcludedPaths instead.
 * @return The buildable object.
 */
@Deprecated public List<StringMatch> getExcludedPaths(){
            return build(excludedPaths);
    }

    public List<StringMatch> buildExcludedPaths(){
            return build(excludedPaths);
    }

    public StringMatch buildExcludedPath(int index){
            return this.excludedPaths.get(index).build();
    }

    public StringMatch buildFirstExcludedPath(){
            return this.excludedPaths.get(0).build();
    }

    public StringMatch buildLastExcludedPath(){
            return this.excludedPaths.get(excludedPaths.size() - 1).build();
    }

    public StringMatch buildMatchingExcludedPath(io.fabric8.kubernetes.api.builder.Predicate<StringMatchBuilder> predicate){
            for (StringMatchBuilder item: excludedPaths) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingExcludedPath(io.fabric8.kubernetes.api.builder.Predicate<StringMatchBuilder> predicate){
            for (StringMatchBuilder item: excludedPaths) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withExcludedPaths(List<StringMatch> excludedPaths){
            if (this.excludedPaths != null) { _visitables.get("excludedPaths").removeAll(this.excludedPaths);}
            if (excludedPaths != null) {this.excludedPaths = new ArrayList<StringMatchBuilder>(); for (StringMatch item : excludedPaths){this.addToExcludedPaths(item);}} else { this.excludedPaths = null;} return (A) this;
    }

    public A withExcludedPaths(StringMatch... excludedPaths){
            if (this.excludedPaths != null) {this.excludedPaths.clear();}
            if (excludedPaths != null) {for (StringMatch item :excludedPaths){ this.addToExcludedPaths(item);}} return (A) this;
    }

    public Boolean hasExcludedPaths(){
            return excludedPaths != null && !excludedPaths.isEmpty();
    }

    public TriggerRuleFluent.ExcludedPathsNested<A> addNewExcludedPath(){
            return new ExcludedPathsNestedImpl();
    }

    public TriggerRuleFluent.ExcludedPathsNested<A> addNewExcludedPathLike(StringMatch item){
            return new ExcludedPathsNestedImpl(-1, item);
    }

    public TriggerRuleFluent.ExcludedPathsNested<A> setNewExcludedPathLike(int index,StringMatch item){
            return new ExcludedPathsNestedImpl(index, item);
    }

    public TriggerRuleFluent.ExcludedPathsNested<A> editExcludedPath(int index){
            if (excludedPaths.size() <= index) throw new RuntimeException("Can't edit excludedPaths. Index exceeds size.");
            return setNewExcludedPathLike(index, buildExcludedPath(index));
    }

    public TriggerRuleFluent.ExcludedPathsNested<A> editFirstExcludedPath(){
            if (excludedPaths.size() == 0) throw new RuntimeException("Can't edit first excludedPaths. The list is empty.");
            return setNewExcludedPathLike(0, buildExcludedPath(0));
    }

    public TriggerRuleFluent.ExcludedPathsNested<A> editLastExcludedPath(){
            int index = excludedPaths.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last excludedPaths. The list is empty.");
            return setNewExcludedPathLike(index, buildExcludedPath(index));
    }

    public TriggerRuleFluent.ExcludedPathsNested<A> editMatchingExcludedPath(io.fabric8.kubernetes.api.builder.Predicate<StringMatchBuilder> predicate){
            int index = -1;
            for (int i=0;i<excludedPaths.size();i++) { 
            if (predicate.apply(excludedPaths.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching excludedPaths. No match found.");
            return setNewExcludedPathLike(index, buildExcludedPath(index));
    }

    public A addToIncludedPaths(int index,StringMatch item){
            if (this.includedPaths == null) {this.includedPaths = new ArrayList<StringMatchBuilder>();}
            StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("includedPaths").add(index >= 0 ? index : _visitables.get("includedPaths").size(), builder);this.includedPaths.add(index >= 0 ? index : includedPaths.size(), builder); return (A)this;
    }

    public A setToIncludedPaths(int index,StringMatch item){
            if (this.includedPaths == null) {this.includedPaths = new ArrayList<StringMatchBuilder>();}
            StringMatchBuilder builder = new StringMatchBuilder(item);
            if (index < 0 || index >= _visitables.get("includedPaths").size()) { _visitables.get("includedPaths").add(builder); } else { _visitables.get("includedPaths").set(index, builder);}
            if (index < 0 || index >= includedPaths.size()) { includedPaths.add(builder); } else { includedPaths.set(index, builder);}
             return (A)this;
    }

    public A addToIncludedPaths(StringMatch... items){
            if (this.includedPaths == null) {this.includedPaths = new ArrayList<StringMatchBuilder>();}
            for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("includedPaths").add(builder);this.includedPaths.add(builder);} return (A)this;
    }

    public A addAllToIncludedPaths(Collection<StringMatch> items){
            if (this.includedPaths == null) {this.includedPaths = new ArrayList<StringMatchBuilder>();}
            for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("includedPaths").add(builder);this.includedPaths.add(builder);} return (A)this;
    }

    public A removeFromIncludedPaths(StringMatch... items){
            for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("includedPaths").remove(builder);if (this.includedPaths != null) {this.includedPaths.remove(builder);}} return (A)this;
    }

    public A removeAllFromIncludedPaths(Collection<StringMatch> items){
            for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("includedPaths").remove(builder);if (this.includedPaths != null) {this.includedPaths.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIncludedPaths(io.fabric8.kubernetes.api.builder.Predicate<StringMatchBuilder> predicate){
            if (includedPaths == null) return (A) this;
            final Iterator<StringMatchBuilder> each = includedPaths.iterator();
            final List visitables = _visitables.get("includedPaths");
            while (each.hasNext()) {
              StringMatchBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIncludedPaths instead.
 * @return The buildable object.
 */
@Deprecated public List<StringMatch> getIncludedPaths(){
            return build(includedPaths);
    }

    public List<StringMatch> buildIncludedPaths(){
            return build(includedPaths);
    }

    public StringMatch buildIncludedPath(int index){
            return this.includedPaths.get(index).build();
    }

    public StringMatch buildFirstIncludedPath(){
            return this.includedPaths.get(0).build();
    }

    public StringMatch buildLastIncludedPath(){
            return this.includedPaths.get(includedPaths.size() - 1).build();
    }

    public StringMatch buildMatchingIncludedPath(io.fabric8.kubernetes.api.builder.Predicate<StringMatchBuilder> predicate){
            for (StringMatchBuilder item: includedPaths) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingIncludedPath(io.fabric8.kubernetes.api.builder.Predicate<StringMatchBuilder> predicate){
            for (StringMatchBuilder item: includedPaths) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withIncludedPaths(List<StringMatch> includedPaths){
            if (this.includedPaths != null) { _visitables.get("includedPaths").removeAll(this.includedPaths);}
            if (includedPaths != null) {this.includedPaths = new ArrayList<StringMatchBuilder>(); for (StringMatch item : includedPaths){this.addToIncludedPaths(item);}} else { this.includedPaths = null;} return (A) this;
    }

    public A withIncludedPaths(StringMatch... includedPaths){
            if (this.includedPaths != null) {this.includedPaths.clear();}
            if (includedPaths != null) {for (StringMatch item :includedPaths){ this.addToIncludedPaths(item);}} return (A) this;
    }

    public Boolean hasIncludedPaths(){
            return includedPaths != null && !includedPaths.isEmpty();
    }

    public TriggerRuleFluent.IncludedPathsNested<A> addNewIncludedPath(){
            return new IncludedPathsNestedImpl();
    }

    public TriggerRuleFluent.IncludedPathsNested<A> addNewIncludedPathLike(StringMatch item){
            return new IncludedPathsNestedImpl(-1, item);
    }

    public TriggerRuleFluent.IncludedPathsNested<A> setNewIncludedPathLike(int index,StringMatch item){
            return new IncludedPathsNestedImpl(index, item);
    }

    public TriggerRuleFluent.IncludedPathsNested<A> editIncludedPath(int index){
            if (includedPaths.size() <= index) throw new RuntimeException("Can't edit includedPaths. Index exceeds size.");
            return setNewIncludedPathLike(index, buildIncludedPath(index));
    }

    public TriggerRuleFluent.IncludedPathsNested<A> editFirstIncludedPath(){
            if (includedPaths.size() == 0) throw new RuntimeException("Can't edit first includedPaths. The list is empty.");
            return setNewIncludedPathLike(0, buildIncludedPath(0));
    }

    public TriggerRuleFluent.IncludedPathsNested<A> editLastIncludedPath(){
            int index = includedPaths.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last includedPaths. The list is empty.");
            return setNewIncludedPathLike(index, buildIncludedPath(index));
    }

    public TriggerRuleFluent.IncludedPathsNested<A> editMatchingIncludedPath(io.fabric8.kubernetes.api.builder.Predicate<StringMatchBuilder> predicate){
            int index = -1;
            for (int i=0;i<includedPaths.size();i++) { 
            if (predicate.apply(includedPaths.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching includedPaths. No match found.");
            return setNewIncludedPathLike(index, buildIncludedPath(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TriggerRuleFluentImpl that = (TriggerRuleFluentImpl) o;
            if (excludedPaths != null ? !excludedPaths.equals(that.excludedPaths) :that.excludedPaths != null) return false;
            if (includedPaths != null ? !includedPaths.equals(that.includedPaths) :that.includedPaths != null) return false;
            return true;
    }


    public class ExcludedPathsNestedImpl<N> extends StringMatchFluentImpl<TriggerRuleFluent.ExcludedPathsNested<N>> implements TriggerRuleFluent.ExcludedPathsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StringMatchBuilder builder;
        private final int index;
    
            ExcludedPathsNestedImpl(int index,StringMatch item){
                    this.index = index;
                    this.builder = new StringMatchBuilder(this, item);
            }
            ExcludedPathsNestedImpl(){
                    this.index = -1;
                    this.builder = new StringMatchBuilder(this);
            }
    
    public N and(){
            return (N) TriggerRuleFluentImpl.this.setToExcludedPaths(index, builder.build());
    }
    public N endExcludedPath(){
            return and();
    }

}
    public class IncludedPathsNestedImpl<N> extends StringMatchFluentImpl<TriggerRuleFluent.IncludedPathsNested<N>> implements TriggerRuleFluent.IncludedPathsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StringMatchBuilder builder;
        private final int index;
    
            IncludedPathsNestedImpl(int index,StringMatch item){
                    this.index = index;
                    this.builder = new StringMatchBuilder(this, item);
            }
            IncludedPathsNestedImpl(){
                    this.index = -1;
                    this.builder = new StringMatchBuilder(this);
            }
    
    public N and(){
            return (N) TriggerRuleFluentImpl.this.setToIncludedPaths(index, builder.build());
    }
    public N endIncludedPath(){
            return and();
    }

}


}
