
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.TLSSettings;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "tlsSettings"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ConfigSource implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private String address;
    /**
     * 
     * 
     */
    @JsonProperty("tlsSettings")
    @JsonPropertyDescription("")
    private TLSSettings tlsSettings;
    private final static long serialVersionUID = 4581588953488020243L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ConfigSource() {
    }

    /**
     * 
     * @param address
     * @param tlsSettings
     */
    public ConfigSource(String address, TLSSettings tlsSettings) {
        super();
        this.address = address;
        this.tlsSettings = tlsSettings;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public String getAddress() {
        return address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tlsSettings")
    public TLSSettings getTlsSettings() {
        return tlsSettings;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tlsSettings")
    public void setTlsSettings(TLSSettings tlsSettings) {
        this.tlsSettings = tlsSettings;
    }

}
