package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConfigSourceBuilder extends ConfigSourceFluentImpl<ConfigSourceBuilder> implements VisitableBuilder<ConfigSource,ConfigSourceBuilder>{

    ConfigSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigSourceBuilder(){
            this(true);
    }
    public ConfigSourceBuilder(Boolean validationEnabled){
            this(new ConfigSource(), validationEnabled);
    }
    public ConfigSourceBuilder(ConfigSourceFluent<?> fluent){
            this(fluent, true);
    }
    public ConfigSourceBuilder(ConfigSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConfigSource(), validationEnabled);
    }
    public ConfigSourceBuilder(ConfigSourceFluent<?> fluent,ConfigSource instance){
            this(fluent, instance, true);
    }
    public ConfigSourceBuilder(ConfigSourceFluent<?> fluent,ConfigSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withTlsSettings(instance.getTlsSettings()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConfigSourceBuilder(ConfigSource instance){
            this(instance,true);
    }
    public ConfigSourceBuilder(ConfigSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withTlsSettings(instance.getTlsSettings()); 
            this.validationEnabled = validationEnabled; 
    }

    public ConfigSource build(){
            ConfigSource buildable = new ConfigSource(fluent.getAddress(),fluent.getTlsSettings());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConfigSourceBuilder that = (ConfigSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
