package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.networking.v1alpha3.TLSSettingsFluent;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import me.snowdrop.istio.api.networking.v1alpha3.TLSSettings;
import java.lang.Boolean;
import me.snowdrop.istio.api.networking.v1alpha3.TLSSettingsBuilder;

public interface ConfigSourceFluent<A extends ConfigSourceFluent<A>> extends Fluent<A>{


    public String getAddress();
    public A withAddress(String address);
    public Boolean hasAddress();
    public A withNewAddress(String arg1);
    public A withNewAddress(StringBuilder arg1);
    public A withNewAddress(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTlsSettings instead.
 * @return The buildable object.
 */
@Deprecated public TLSSettings getTlsSettings();
    public TLSSettings buildTlsSettings();
    public A withTlsSettings(TLSSettings tlsSettings);
    public Boolean hasTlsSettings();
    public ConfigSourceFluent.TlsSettingsNested<A> withNewTlsSettings();
    public ConfigSourceFluent.TlsSettingsNested<A> withNewTlsSettingsLike(TLSSettings item);
    public ConfigSourceFluent.TlsSettingsNested<A> editTlsSettings();
    public ConfigSourceFluent.TlsSettingsNested<A> editOrNewTlsSettings();
    public ConfigSourceFluent.TlsSettingsNested<A> editOrNewTlsSettingsLike(TLSSettings item);

    public interface TlsSettingsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TLSSettingsFluent<ConfigSourceFluent.TlsSettingsNested<N>>{

        
    public N and();    public N endTlsSettings();
}


}
