package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import me.snowdrop.istio.api.networking.v1alpha3.TLSSettingsFluentImpl;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import me.snowdrop.istio.api.networking.v1alpha3.TLSSettings;
import java.lang.Boolean;
import me.snowdrop.istio.api.networking.v1alpha3.TLSSettingsBuilder;

public class ConfigSourceFluentImpl<A extends ConfigSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConfigSourceFluent<A>{

    private String address;
    private TLSSettingsBuilder tlsSettings;

    public ConfigSourceFluentImpl(){
    }
    public ConfigSourceFluentImpl(ConfigSource instance){
            this.withAddress(instance.getAddress()); 
            this.withTlsSettings(instance.getTlsSettings()); 
    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A withNewAddress(String arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuilder arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1){
            return (A)withAddress(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTlsSettings instead.
 * @return The buildable object.
 */
@Deprecated public TLSSettings getTlsSettings(){
            return this.tlsSettings!=null?this.tlsSettings.build():null;
    }

    public TLSSettings buildTlsSettings(){
            return this.tlsSettings!=null?this.tlsSettings.build():null;
    }

    public A withTlsSettings(TLSSettings tlsSettings){
            _visitables.get("tlsSettings").remove(this.tlsSettings);
            if (tlsSettings!=null){ this.tlsSettings= new TLSSettingsBuilder(tlsSettings); _visitables.get("tlsSettings").add(this.tlsSettings);} return (A) this;
    }

    public Boolean hasTlsSettings(){
            return this.tlsSettings != null;
    }

    public ConfigSourceFluent.TlsSettingsNested<A> withNewTlsSettings(){
            return new TlsSettingsNestedImpl();
    }

    public ConfigSourceFluent.TlsSettingsNested<A> withNewTlsSettingsLike(TLSSettings item){
            return new TlsSettingsNestedImpl(item);
    }

    public ConfigSourceFluent.TlsSettingsNested<A> editTlsSettings(){
            return withNewTlsSettingsLike(getTlsSettings());
    }

    public ConfigSourceFluent.TlsSettingsNested<A> editOrNewTlsSettings(){
            return withNewTlsSettingsLike(getTlsSettings() != null ? getTlsSettings(): new TLSSettingsBuilder().build());
    }

    public ConfigSourceFluent.TlsSettingsNested<A> editOrNewTlsSettingsLike(TLSSettings item){
            return withNewTlsSettingsLike(getTlsSettings() != null ? getTlsSettings(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ConfigSourceFluentImpl that = (ConfigSourceFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (tlsSettings != null ? !tlsSettings.equals(that.tlsSettings) :that.tlsSettings != null) return false;
            return true;
    }


    public class TlsSettingsNestedImpl<N> extends TLSSettingsFluentImpl<ConfigSourceFluent.TlsSettingsNested<N>> implements ConfigSourceFluent.TlsSettingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TLSSettingsBuilder builder;
    
            TlsSettingsNestedImpl(TLSSettings item){
                    this.builder = new TLSSettingsBuilder(this, item);
            }
            TlsSettingsNestedImpl(){
                    this.builder = new TLSSettingsBuilder(this);
            }
    
    public N and(){
            return (N) ConfigSourceFluentImpl.this.withTlsSettings(builder.build());
    }
    public N endTlsSettings(){
            return and();
    }

}


}
