package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class DistributeFluentImpl<A extends DistributeFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DistributeFluent<A>{

    private String from;
    private Map<String,Integer> to;

    public DistributeFluentImpl(){
    }
    public DistributeFluentImpl(Distribute instance){
            this.withFrom(instance.getFrom()); 
            this.withTo(instance.getTo()); 
    }

    public String getFrom(){
            return this.from;
    }

    public A withFrom(String from){
            this.from=from; return (A) this;
    }

    public Boolean hasFrom(){
            return this.from != null;
    }

    public A withNewFrom(String arg1){
            return (A)withFrom(new String(arg1));
    }

    public A withNewFrom(StringBuilder arg1){
            return (A)withFrom(new String(arg1));
    }

    public A withNewFrom(StringBuffer arg1){
            return (A)withFrom(new String(arg1));
    }

    public A addToTo(String key,Integer value){
            if(this.to == null && key != null && value != null) { this.to = new LinkedHashMap<String,Integer>(); }
            if(key != null && value != null) {this.to.put(key, value);} return (A)this;
    }

    public A addToTo(Map<String,Integer> map){
            if(this.to == null && map != null) { this.to = new LinkedHashMap<String,Integer>(); }
            if(map != null) { this.to.putAll(map);} return (A)this;
    }

    public A removeFromTo(String key){
            if(this.to == null) { return (A) this; }
            if(key != null && this.to != null) {this.to.remove(key);} return (A)this;
    }

    public A removeFromTo(Map<String,Integer> map){
            if(this.to == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.to != null){this.to.remove(key);}}} return (A)this;
    }

    public Map<String,Integer> getTo(){
            return this.to;
    }

    public A withTo(Map<String,Integer> to){
            if (to == null) { this.to =  null;} else {this.to = new LinkedHashMap<String,Integer>(to);} return (A) this;
    }

    public Boolean hasTo(){
            return this.to != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DistributeFluentImpl that = (DistributeFluentImpl) o;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (to != null ? !to.equals(that.to) :that.to != null) return false;
            return true;
    }




}
